/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.engine.assistant.core.definition.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetBucketResourceGroupResult;
import com.aliyun.oss.model.SetBucketResourceGroupRequest;
import com.aliyun.oss.model.VoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketResourceGroupService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketResourceGroupService.class);

    public AliyunBucketResourceGroupService(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public VoidResult setBucketResourceGroup(SetBucketResourceGroupRequest request) {
        String function = "setBucketResourceGroup";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.setBucketResourceGroup(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public GetBucketResourceGroupResult getBucketResourceGroup(String bucketName) {
        String function = "getBucketResourceGroup";
        OSS client = (OSS)this.getClient();
        try {
            GetBucketResourceGroupResult getBucketResourceGroupResult = client.getBucketResourceGroup(bucketName);
            return getBucketResourceGroupResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

