/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.adapter;

import cn.herodotus.oss.definition.adapter.OssBucketAdapter;
import cn.herodotus.oss.definition.domain.BucketDomain;
import cn.herodotus.oss.dialect.aliyun.converter.AliyunBucketToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.utils.ConverterUtils;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketAdapter
extends BaseAliyunService
implements OssBucketAdapter {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketAdapter.class);

    public AliyunBucketAdapter(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public boolean doesBucketExist(String bucketName) {
        String function = "Aliyun doesBucketExist";
        OSS client = (OSS)this.getClient();
        try {
            boolean bl = client.doesBucketExist(bucketName);
            return bl;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<BucketDomain> listBuckets() {
        String function = "listBuckets";
        OSS client = (OSS)this.getClient();
        try {
            List list = ConverterUtils.toDomains((List)client.listBuckets(), (Converter)new AliyunBucketToDomainConverter());
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

