/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.definition.core.client;

import cn.herodotus.oss.definition.core.client.AbstractOssClientPooledObjectFactory;
import cn.herodotus.oss.definition.core.exception.OssClientPoolErrorException;
import cn.herodotus.oss.definition.core.properties.AbstractOssProperties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOssClientObjectPool<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOssClientObjectPool.class);
    private final GenericObjectPool<T> genericObjectPool;

    public AbstractOssClientObjectPool(AbstractOssClientPooledObjectFactory<T> factory) {
        AbstractOssProperties properties = factory.getOssProperties();
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(properties.getPool().getMaxTotal().intValue());
        config.setMaxIdle(properties.getPool().getMaxIdle().intValue());
        config.setMinIdle(properties.getPool().getMinIdle().intValue());
        config.setMaxWait(properties.getPool().getMaxWait());
        config.setMinEvictableIdleTime(properties.getPool().getMinEvictableIdleTime());
        config.setSoftMinEvictableIdleTime(properties.getPool().getSoftMinEvictableIdleTime());
        config.setLifo(properties.getPool().getLifo().booleanValue());
        config.setBlockWhenExhausted(properties.getPool().getBlockWhenExhausted().booleanValue());
        this.genericObjectPool = new GenericObjectPool(factory, config);
    }

    public T get() {
        try {
            Object client = this.genericObjectPool.borrowObject();
            log.debug("[Herodotus] |- Fetch oss client from object pool.");
            return (T)client;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch oss client from pool.", (Throwable)e);
            throw new OssClientPoolErrorException("Can not fetch oss client from pool.");
        }
    }

    public void close(T client) {
        if (ObjectUtils.isNotEmpty(client)) {
            log.debug("[Herodotus] |- Close oss client.");
            this.genericObjectPool.returnObject(client);
        }
    }
}

