/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.stamp;

import cn.herodotus.engine.cache.jetcache.stamp.AbstractStampManager;
import cn.herodotus.engine.web.service.properties.SecureProperties;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLimitedStampManager
extends AbstractStampManager<String, Long> {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitedStampManager.class);
    private final SecureProperties secureProperties;

    public AccessLimitedStampManager(SecureProperties secureProperties) {
        super("cache:token:access_limited:", secureProperties.getAccessLimited().getExpire());
        this.secureProperties = secureProperties;
    }

    public SecureProperties getSecureProperties() {
        return this.secureProperties;
    }

    public Long nextStamp(String key) {
        return 1L;
    }

    public Duration calculateRemainingTime(Duration configuredDuration, String expireKey) {
        Long begin = (Long)this.get(expireKey);
        Long current = System.currentTimeMillis();
        long interval = current - begin;
        log.debug("[Herodotus] |- AccessLimited operation interval [{}] millis.", (Object)interval);
        Duration duration = !configuredDuration.isZero() ? configuredDuration.minusMillis(interval) : this.getExpire().minusMillis(interval);
        return duration;
    }
}

