/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.secure;

import cn.herodotus.engine.web.core.annotation.Idempotent;
import cn.herodotus.engine.web.core.exception.RepeatSubmissionException;
import cn.herodotus.engine.web.service.secure.AccessLimitedHandler;
import cn.herodotus.engine.web.service.stamp.IdempotentStampManager;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitedHandler.class);

    public static boolean handle(String key, Idempotent idempotent, String url, IdempotentStampManager idempotentStampManager) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            String token = (String)idempotentStampManager.get(key);
            if (StringUtils.isBlank((CharSequence)token)) {
                Duration configuredDuration = Duration.ZERO;
                String annotationExpire = idempotent.expire();
                if (StringUtils.isNotBlank((CharSequence)annotationExpire)) {
                    try {
                        configuredDuration = Duration.parse(annotationExpire);
                    }
                    catch (DateTimeParseException e) {
                        log.warn("[Herodotus] |- Idempotent duration value is incorrect, on api [{}].", (Object)url);
                    }
                }
                if (!configuredDuration.isZero()) {
                    idempotentStampManager.create(key, configuredDuration);
                } else {
                    idempotentStampManager.create(key);
                }
                return true;
            }
            throw new RepeatSubmissionException("Don't Repeat Submission");
        }
        return true;
    }
}

