/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.properties;

import cn.herodotus.engine.core.definition.utils.WellFormedUtils;
import com.google.common.base.MoreObjects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="herodotus.endpoint")
public class EndpointProperties {
    private String uaaServiceName;
    private String upmsServiceName;
    private String messageServiceName;
    private String ossServiceName;
    private String gatewayServiceUri;
    private String uaaServiceUri;
    private String upmsServiceUri;
    private String messageServiceUri;
    private String ossServiceUri;
    private String authorizationUri;
    private String authorizationEndpoint = "/oauth2/authorize";
    private String pushedAuthorizationRequestUri;
    private String pushedAuthorizationRequestEndpoint = "/oauth2/par";
    private String accessTokenUri;
    private String accessTokenEndpoint = "/oauth2/token";
    private String jwkSetUri;
    private String jwkSetEndpoint = "/oauth2/jwks";
    private String tokenRevocationUri;
    private String tokenRevocationEndpoint = "/oauth2/revoke";
    private String tokenIntrospectionUri;
    private String tokenIntrospectionEndpoint = "/oauth2/introspect";
    private String deviceAuthorizationUri;
    private String deviceAuthorizationEndpoint = "/oauth2/device_authorization";
    private String deviceVerificationUri;
    private String deviceVerificationEndpoint = "/oauth2/device_verification";
    private String oidcClientRegistrationUri;
    private String oidcClientRegistrationEndpoint = "/connect/register";
    private String oidcLogoutUri;
    private String oidcLogoutEndpoint = "/connect/logout";
    private String oidcUserInfoUri;
    private String oidcUserInfoEndpoint = "/userinfo";
    private String issuerUri;

    public String getUaaServiceName() {
        return this.uaaServiceName;
    }

    public void setUaaServiceName(String uaaServiceName) {
        this.uaaServiceName = uaaServiceName;
    }

    public String getUpmsServiceName() {
        return this.upmsServiceName;
    }

    public void setUpmsServiceName(String upmsServiceName) {
        this.upmsServiceName = upmsServiceName;
    }

    public String getMessageServiceName() {
        return this.messageServiceName;
    }

    public void setMessageServiceName(String messageServiceName) {
        this.messageServiceName = messageServiceName;
    }

    public String getOssServiceName() {
        return this.ossServiceName;
    }

    public void setOssServiceName(String ossServiceName) {
        this.ossServiceName = ossServiceName;
    }

    public String getGatewayServiceUri() {
        return this.gatewayServiceUri;
    }

    public void setGatewayServiceUri(String gatewayServiceUri) {
        this.gatewayServiceUri = gatewayServiceUri;
    }

    public String getUaaServiceUri() {
        return WellFormedUtils.serviceUri((String)this.uaaServiceUri, (String)this.getUaaServiceName(), (String)this.getGatewayServiceUri(), (String)"UAA");
    }

    public void setUaaServiceUri(String uaaServiceUri) {
        this.uaaServiceUri = uaaServiceUri;
    }

    public String getUpmsServiceUri() {
        return WellFormedUtils.serviceUri((String)this.upmsServiceUri, (String)this.getUpmsServiceName(), (String)this.getGatewayServiceUri(), (String)"UPMS");
    }

    public void setUpmsServiceUri(String upmsServiceUri) {
        this.upmsServiceUri = upmsServiceUri;
    }

    public String getMessageServiceUri() {
        return WellFormedUtils.serviceUri((String)this.messageServiceUri, (String)this.getMessageServiceName(), (String)this.getGatewayServiceUri(), (String)"MESSAGE");
    }

    public void setMessageServiceUri(String messageServiceUri) {
        this.messageServiceUri = messageServiceUri;
    }

    public String getOssServiceUri() {
        return WellFormedUtils.serviceUri((String)this.ossServiceUri, (String)this.getOssServiceName(), (String)this.getGatewayServiceUri(), (String)"OSS");
    }

    public void setOssServiceUri(String ossServiceUri) {
        this.ossServiceUri = ossServiceUri;
    }

    public String getAuthorizationUri() {
        return WellFormedUtils.sasUri((String)this.authorizationUri, (String)this.getAuthorizationEndpoint(), (String)this.getIssuerUri());
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public String getPushedAuthorizationRequestUri() {
        return WellFormedUtils.sasUri((String)this.pushedAuthorizationRequestUri, (String)this.getPushedAuthorizationRequestEndpoint(), (String)this.getIssuerUri());
    }

    public void setPushedAuthorizationRequestUri(String pushedAuthorizationRequestUri) {
        this.pushedAuthorizationRequestUri = pushedAuthorizationRequestUri;
    }

    public String getAccessTokenUri() {
        return WellFormedUtils.sasUri((String)this.accessTokenUri, (String)this.getAccessTokenEndpoint(), (String)this.getIssuerUri());
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public String getJwkSetUri() {
        return WellFormedUtils.sasUri((String)this.jwkSetUri, (String)this.getJwkSetEndpoint(), (String)this.getIssuerUri());
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public String getTokenRevocationUri() {
        return WellFormedUtils.sasUri((String)this.tokenRevocationUri, (String)this.getTokenRevocationEndpoint(), (String)this.getIssuerUri());
    }

    public void setTokenRevocationUri(String tokenRevocationUri) {
        this.tokenRevocationUri = tokenRevocationUri;
    }

    public String getTokenIntrospectionUri() {
        return WellFormedUtils.sasUri((String)this.tokenIntrospectionUri, (String)this.getTokenIntrospectionEndpoint(), (String)this.getIssuerUri());
    }

    public void setTokenIntrospectionUri(String tokenIntrospectionUri) {
        this.tokenIntrospectionUri = tokenIntrospectionUri;
    }

    public String getDeviceAuthorizationUri() {
        return WellFormedUtils.sasUri((String)this.deviceAuthorizationUri, (String)this.getDeviceAuthorizationEndpoint(), (String)this.getIssuerUri());
    }

    public void setDeviceAuthorizationUri(String deviceAuthorizationUri) {
        this.deviceAuthorizationUri = deviceAuthorizationUri;
    }

    public String getDeviceVerificationUri() {
        return WellFormedUtils.sasUri((String)this.deviceVerificationUri, (String)this.getDeviceVerificationEndpoint(), (String)this.getIssuerUri());
    }

    public void setDeviceVerificationUri(String deviceVerificationUri) {
        this.deviceVerificationUri = deviceVerificationUri;
    }

    public String getOidcClientRegistrationUri() {
        return WellFormedUtils.sasUri((String)this.oidcClientRegistrationUri, (String)this.getOidcClientRegistrationEndpoint(), (String)this.getIssuerUri());
    }

    public void setOidcClientRegistrationUri(String oidcClientRegistrationUri) {
        this.oidcClientRegistrationUri = oidcClientRegistrationUri;
    }

    public String getOidcLogoutUri() {
        return WellFormedUtils.sasUri((String)this.oidcLogoutUri, (String)this.getOidcLogoutEndpoint(), (String)this.getIssuerUri());
    }

    public void setOidcLogoutUri(String oidcLogoutUri) {
        this.oidcLogoutUri = oidcLogoutUri;
    }

    public String getOidcUserInfoUri() {
        return WellFormedUtils.sasUri((String)this.oidcUserInfoUri, (String)this.getOidcUserInfoEndpoint(), (String)this.getIssuerUri());
    }

    public void setOidcUserInfoUri(String oidcUserInfoUri) {
        this.oidcUserInfoUri = oidcUserInfoUri;
    }

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }

    public String getJwkSetEndpoint() {
        return this.jwkSetEndpoint;
    }

    public void setJwkSetEndpoint(String jwkSetEndpoint) {
        this.jwkSetEndpoint = jwkSetEndpoint;
    }

    public String getTokenRevocationEndpoint() {
        return this.tokenRevocationEndpoint;
    }

    public void setTokenRevocationEndpoint(String tokenRevocationEndpoint) {
        this.tokenRevocationEndpoint = tokenRevocationEndpoint;
    }

    public String getTokenIntrospectionEndpoint() {
        return this.tokenIntrospectionEndpoint;
    }

    public void setTokenIntrospectionEndpoint(String tokenIntrospectionEndpoint) {
        this.tokenIntrospectionEndpoint = tokenIntrospectionEndpoint;
    }

    public String getDeviceAuthorizationEndpoint() {
        return this.deviceAuthorizationEndpoint;
    }

    public void setDeviceAuthorizationEndpoint(String deviceAuthorizationEndpoint) {
        this.deviceAuthorizationEndpoint = deviceAuthorizationEndpoint;
    }

    public String getDeviceVerificationEndpoint() {
        return this.deviceVerificationEndpoint;
    }

    public void setDeviceVerificationEndpoint(String deviceVerificationEndpoint) {
        this.deviceVerificationEndpoint = deviceVerificationEndpoint;
    }

    public String getOidcClientRegistrationEndpoint() {
        return this.oidcClientRegistrationEndpoint;
    }

    public void setOidcClientRegistrationEndpoint(String oidcClientRegistrationEndpoint) {
        this.oidcClientRegistrationEndpoint = oidcClientRegistrationEndpoint;
    }

    public String getOidcUserInfoEndpoint() {
        return this.oidcUserInfoEndpoint;
    }

    public void setOidcUserInfoEndpoint(String oidcUserInfoEndpoint) {
        this.oidcUserInfoEndpoint = oidcUserInfoEndpoint;
    }

    public String getOidcLogoutEndpoint() {
        return this.oidcLogoutEndpoint;
    }

    public void setOidcLogoutEndpoint(String oidcLogoutEndpoint) {
        this.oidcLogoutEndpoint = oidcLogoutEndpoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uaaServiceName", (Object)this.uaaServiceName).add("upmsServiceName", (Object)this.upmsServiceName).add("gatewayServiceUri", (Object)this.gatewayServiceUri).add("uaaServiceUri", (Object)this.uaaServiceUri).add("upmsServiceUri", (Object)this.upmsServiceUri).add("authorizationUri", (Object)this.authorizationUri).add("authorizationEndpoint", (Object)this.authorizationEndpoint).add("accessTokenUri", (Object)this.accessTokenUri).add("accessTokenEndpoint", (Object)this.accessTokenEndpoint).add("jwkSetUri", (Object)this.jwkSetUri).add("jwkSetEndpoint", (Object)this.jwkSetEndpoint).add("tokenRevocationUri", (Object)this.tokenRevocationUri).add("tokenRevocationEndpoint", (Object)this.tokenRevocationEndpoint).add("tokenIntrospectionUri", (Object)this.tokenIntrospectionUri).add("tokenIntrospectionEndpoint", (Object)this.tokenIntrospectionEndpoint).add("deviceAuthorizationUri", (Object)this.deviceAuthorizationUri).add("deviceAuthorizationEndpoint", (Object)this.deviceAuthorizationEndpoint).add("deviceVerificationUri", (Object)this.deviceVerificationUri).add("deviceVerificationEndpoint", (Object)this.deviceVerificationEndpoint).add("oidcClientRegistrationUri", (Object)this.oidcClientRegistrationUri).add("oidcClientRegistrationEndpoint", (Object)this.oidcClientRegistrationEndpoint).add("oidcLogoutUri", (Object)this.oidcLogoutUri).add("oidcLogoutEndpoint", (Object)this.oidcLogoutEndpoint).add("oidcUserInfoUri", (Object)this.oidcUserInfoUri).add("oidcUserInfoEndpoint", (Object)this.oidcUserInfoEndpoint).add("issuerUri", (Object)this.issuerUri).toString();
    }
}

