/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.initializer;

import cn.herodotus.engine.core.definition.enums.Protocol;
import cn.herodotus.engine.core.definition.utils.WellFormedUtils;
import cn.herodotus.engine.core.foundation.context.ServiceContextHolder;
import cn.herodotus.engine.core.foundation.enums.Architecture;
import cn.herodotus.engine.core.foundation.enums.DataAccessStrategy;
import cn.herodotus.engine.web.service.properties.EndpointProperties;
import cn.herodotus.engine.web.service.properties.PlatformProperties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class ServiceContextHolderBuilder {
    private PlatformProperties platformProperties;
    private EndpointProperties endpointProperties;
    private ServerProperties serverProperties;

    private ServiceContextHolderBuilder() {
    }

    public static ServiceContextHolderBuilder builder() {
        return new ServiceContextHolderBuilder();
    }

    public ServiceContextHolderBuilder platformProperties(PlatformProperties platformProperties) {
        this.platformProperties = platformProperties;
        return this;
    }

    public ServiceContextHolderBuilder endpointProperties(EndpointProperties endpointProperties) {
        this.endpointProperties = endpointProperties;
        return this;
    }

    public ServiceContextHolderBuilder serverProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
        return this;
    }

    public void build() {
        ServiceContextHolder.setPort((String)String.valueOf(this.getPort()));
        ServiceContextHolder.setIp((String)this.getHostAddress());
        ServiceContextHolder.setContextPath((String)this.serverProperties.getServlet().getContextPath());
        this.setProperties(this.platformProperties, this.endpointProperties);
    }

    private String getHostAddress() {
        String address = WellFormedUtils.getHostAddress();
        if (ObjectUtils.isNotEmpty((Object)this.serverProperties.getAddress())) {
            address = this.serverProperties.getAddress().getHostAddress();
        }
        if (StringUtils.isNotBlank((CharSequence)address)) {
            return address;
        }
        return "localhost";
    }

    private Integer getPort() {
        Integer port = this.serverProperties.getPort();
        if (ObjectUtils.isNotEmpty((Object)port)) {
            return port;
        }
        return 8080;
    }

    private void setProperties(PlatformProperties platformProperties, EndpointProperties endpointProperties) {
        ServiceContextHolder.setArchitecture((Architecture)platformProperties.getArchitecture());
        ServiceContextHolder.setDataAccessStrategy((DataAccessStrategy)platformProperties.getDataAccessStrategy());
        ServiceContextHolder.setProtocol((Protocol)platformProperties.getProtocol());
        String issuerUri = endpointProperties.getIssuerUri();
        if (StringUtils.isNotBlank((CharSequence)issuerUri)) {
            if (platformProperties.getArchitecture() == Architecture.MONOCOQUE) {
                ServiceContextHolder.setGatewayServiceUri((String)issuerUri);
                ServiceContextHolder.setUaaServiceUri((String)issuerUri);
                ServiceContextHolder.setUpmsServiceUri((String)issuerUri);
                ServiceContextHolder.setMessageServiceUri((String)issuerUri);
                ServiceContextHolder.setOssServiceUri((String)issuerUri);
            } else {
                ServiceContextHolder.setUaaServiceName((String)endpointProperties.getUaaServiceName());
                ServiceContextHolder.setUpmsServiceName((String)endpointProperties.getUpmsServiceName());
                ServiceContextHolder.setMessageServiceName((String)endpointProperties.getMessageServiceName());
                ServiceContextHolder.setOssServiceName((String)endpointProperties.getOssServiceName());
                ServiceContextHolder.setGatewayServiceUri((String)endpointProperties.getGatewayServiceUri());
                ServiceContextHolder.setUaaServiceUri((String)endpointProperties.getUaaServiceUri());
                ServiceContextHolder.setUpmsServiceUri((String)endpointProperties.getUpmsServiceUri());
                ServiceContextHolder.setMessageServiceUri((String)endpointProperties.getMessageServiceUri());
                ServiceContextHolder.setOssServiceUri((String)endpointProperties.getOssServiceUri());
            }
            ServiceContextHolder.setAuthorizationUri((String)endpointProperties.getAuthorizationUri());
            ServiceContextHolder.setAuthorizationEndpoint((String)endpointProperties.getAuthorizationEndpoint());
            ServiceContextHolder.setPushedAuthorizationRequestUri((String)endpointProperties.getPushedAuthorizationRequestUri());
            ServiceContextHolder.setPushedAuthorizationRequestEndpoint((String)endpointProperties.getPushedAuthorizationRequestEndpoint());
            ServiceContextHolder.setAccessTokenUri((String)endpointProperties.getAccessTokenUri());
            ServiceContextHolder.setAccessTokenEndpoint((String)endpointProperties.getAccessTokenEndpoint());
            ServiceContextHolder.setJwkSetUri((String)endpointProperties.getJwkSetUri());
            ServiceContextHolder.setJwkSetEndpoint((String)endpointProperties.getJwkSetEndpoint());
            ServiceContextHolder.setTokenRevocationUri((String)endpointProperties.getTokenRevocationUri());
            ServiceContextHolder.setTokenRevocationEndpoint((String)endpointProperties.getTokenRevocationEndpoint());
            ServiceContextHolder.setTokenIntrospectionUri((String)endpointProperties.getTokenIntrospectionUri());
            ServiceContextHolder.setTokenIntrospectionEndpoint((String)endpointProperties.getTokenIntrospectionEndpoint());
            ServiceContextHolder.setDeviceAuthorizationUri((String)endpointProperties.getDeviceAuthorizationUri());
            ServiceContextHolder.setDeviceAuthorizationEndpoint((String)endpointProperties.getDeviceAuthorizationEndpoint());
            ServiceContextHolder.setDeviceVerificationUri((String)endpointProperties.getDeviceVerificationUri());
            ServiceContextHolder.setDeviceVerificationEndpoint((String)endpointProperties.getDeviceVerificationEndpoint());
            ServiceContextHolder.setOidcClientRegistrationUri((String)endpointProperties.getOidcClientRegistrationUri());
            ServiceContextHolder.setOidcClientRegistrationEndpoint((String)endpointProperties.getOidcClientRegistrationEndpoint());
            ServiceContextHolder.setOidcLogoutUri((String)endpointProperties.getOidcLogoutUri());
            ServiceContextHolder.setOidcLogoutEndpoint((String)endpointProperties.getOidcLogoutEndpoint());
            ServiceContextHolder.setOidcUserInfoUri((String)endpointProperties.getOidcUserInfoUri());
            ServiceContextHolder.setOidcUserInfoEndpoint((String)endpointProperties.getOidcUserInfoEndpoint());
            ServiceContextHolder.setIssuerUri((String)issuerUri);
        }
    }
}

