/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.initializer;

import cn.herodotus.engine.core.definition.utils.WellFormedUtils;
import cn.herodotus.engine.message.core.definition.strategy.RestMappingScanEventManager;
import cn.herodotus.engine.message.core.domain.RestMapping;
import cn.herodotus.engine.web.core.support.WebPropertyFinder;
import cn.herodotus.engine.web.service.properties.ServiceProperties;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractRestMappingScanner
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestMappingScanner.class);
    private final ServiceProperties.Scan scan;
    private final RestMappingScanEventManager restMappingScanEventManager;

    protected AbstractRestMappingScanner(ServiceProperties.Scan scan, RestMappingScanEventManager restMappingScanEventManager) {
        this.scan = scan;
        this.restMappingScanEventManager = restMappingScanEventManager;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        log.debug("[Herodotus] |- [R1] Application is READY, start to scan request mapping!");
        this.onApplicationEvent((ApplicationContext)applicationContext);
    }

    protected abstract void onApplicationEvent(ApplicationContext var1);

    protected boolean isExcludedRequestMapping(HandlerMethod handlerMethod) {
        if (!this.isSpringAnnotationMatched(handlerMethod)) {
            return true;
        }
        return !this.isSwaggerAnnotationMatched(handlerMethod);
    }

    protected boolean isSpringAnnotationMatched(HandlerMethod handlerMethod) {
        if (this.scan.getJustScanRestController().booleanValue()) {
            return handlerMethod.getMethod().getDeclaringClass().getAnnotation(RestController.class) != null;
        }
        return true;
    }

    protected boolean isSwaggerAnnotationMatched(HandlerMethod handlerMethod) {
        if (handlerMethod.getMethodAnnotation(Hidden.class) != null) {
            return false;
        }
        Operation operation = (Operation)handlerMethod.getMethodAnnotation(Operation.class);
        return ObjectUtils.isNotEmpty((Object)operation) && !operation.hidden();
    }

    protected boolean isLegalGroup(String className) {
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            List<String> groupIds = this.scan.getScanGroupIds();
            List result = groupIds.stream().filter(groupId -> Strings.CS.contains((CharSequence)className, (CharSequence)groupId)).collect(Collectors.toList());
            return CollectionUtils.sizeIsEmpty(result);
        }
        return true;
    }

    protected String createCode(String url, String requestMethods) {
        String[] search = new String[]{"{", "}", "/"};
        String[] replacement = new String[]{"", "", ":"};
        String code = StringUtils.replaceEach((String)url, (String[])search, (String[])replacement);
        Object result = StringUtils.isNotBlank((CharSequence)requestMethods) ? StringUtils.lowerCase((String)requestMethods) + code : Strings.CS.removeStart(code, (CharSequence)":");
        log.trace("[Herodotus] |- Create code [{}] for Request [{}] : [{}]", new Object[]{result, requestMethods, url});
        return result;
    }

    protected boolean notExecuteScanning() {
        return !this.restMappingScanEventManager.isPerformScan();
    }

    protected void complete(String serviceId, List<RestMapping> resources) {
        if (CollectionUtils.isNotEmpty(resources)) {
            log.debug("[Herodotus] |- [R2] Request mapping scan found [{}] resources in service [{}], go to next stage!", (Object)serviceId, (Object)resources.size());
            this.restMappingScanEventManager.postProcess(resources);
        } else {
            log.debug("[Herodotus] |- [R2] Request mapping scan can not find any resources in service [{}]!", (Object)serviceId);
        }
        log.info("[Herodotus] |- Request Mapping Scan for Service: [{}] FINISHED!", (Object)serviceId);
    }

    protected String getContextPath(ApplicationContext applicationContext) {
        String contextPath = WebPropertyFinder.getContextPath((ApplicationContext)applicationContext);
        if (StringUtils.isNotBlank((CharSequence)contextPath) && !Strings.CS.equals(contextPath, "/")) {
            return WellFormedUtils.robustness((String)contextPath, (String)"/", (boolean)false, (boolean)false);
        }
        return "";
    }
}

