/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.secure;

import cn.herodotus.engine.web.core.annotation.AccessLimited;
import cn.herodotus.engine.web.core.exception.FrequentRequestsException;
import cn.herodotus.engine.web.service.stamp.AccessLimitedStampManager;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLimitedHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessLimitedHandler.class);

    public static boolean handle(String key, AccessLimited accessLimited, String url, AccessLimitedStampManager accessLimitedStampManager) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            String annotationDuration;
            int maxTimes = accessLimitedStampManager.getSecureProperties().getAccessLimited().getMaxTimes();
            Duration expireDuration = Duration.ZERO;
            int annotationMaxTimes = accessLimited.maxTimes();
            if (annotationMaxTimes != 0) {
                maxTimes = annotationMaxTimes;
            }
            if (StringUtils.isNotBlank((CharSequence)(annotationDuration = accessLimited.duration()))) {
                try {
                    expireDuration = Duration.parse(annotationDuration);
                }
                catch (DateTimeParseException e) {
                    log.warn("[Herodotus] |- AccessLimited duration value is incorrect, on api [{}].", (Object)url);
                }
            }
            String expireKey = key + "_expire";
            Long times = (Long)accessLimitedStampManager.get(key);
            if (ObjectUtils.isEmpty((Object)times) || times == 0L) {
                if (!expireDuration.isZero()) {
                    accessLimitedStampManager.create(key, expireDuration);
                    accessLimitedStampManager.put(expireKey, System.currentTimeMillis(), expireDuration);
                } else {
                    accessLimitedStampManager.create(key);
                    accessLimitedStampManager.put(expireKey, System.currentTimeMillis());
                }
                return true;
            }
            log.debug("[Herodotus] |- AccessLimited request [{}] times.", (Object)times);
            if (times <= (long)maxTimes) {
                Duration newDuration = accessLimitedStampManager.calculateRemainingTime(expireDuration, expireKey);
                accessLimitedStampManager.put(key, times + 1L, newDuration);
                return true;
            }
            throw new FrequentRequestsException("Requests are too frequent. Please try again later!");
        }
        return true;
    }
}

