/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.properties;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="herodotus.service")
public class ServiceProperties {
    private Scan scan = new Scan();

    public Scan getScan() {
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scan", (Object)this.scan).toString();
    }

    public static class Scan {
        private Boolean enabled = true;
        private List<String> scanGroupIds;
        private Boolean justScanRestController = false;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<String> getScanGroupIds() {
            List<String> defaultGroupIds = Stream.of("cn.herodotus", "org.dromara").toList();
            if (CollectionUtils.isEmpty(this.scanGroupIds)) {
                this.scanGroupIds = new ArrayList<String>();
            }
            this.scanGroupIds.addAll(defaultGroupIds);
            return this.scanGroupIds;
        }

        public void setScanGroupIds(List<String> scanGroupIds) {
            this.scanGroupIds = scanGroupIds;
        }

        public Boolean getJustScanRestController() {
            return this.justScanRestController;
        }

        public void setJustScanRestController(Boolean justScanRestController) {
            this.justScanRestController = justScanRestController;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).add("justScanRestController", (Object)this.justScanRestController).toString();
        }
    }
}

