/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.service.config;

import cn.herodotus.engine.core.definition.function.ErrorCodeMapperBuilderCustomizer;
import cn.herodotus.engine.core.foundation.context.ServiceContextHolder;
import cn.herodotus.engine.web.core.support.WebPropertyFinder;
import cn.herodotus.engine.web.service.config.SecureStampConfiguration;
import cn.herodotus.engine.web.service.config.SpringdocConfiguration;
import cn.herodotus.engine.web.service.customizer.Jackson2XssObjectMapperBuilderCustomizer;
import cn.herodotus.engine.web.service.customizer.WebErrorCodeMapperBuilderCustomizer;
import cn.herodotus.engine.web.service.initializer.ServiceContextHolderBuilder;
import cn.herodotus.engine.web.service.properties.EndpointProperties;
import cn.herodotus.engine.web.service.properties.PlatformProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EndpointProperties.class, PlatformProperties.class})
@Import(value={SpringdocConfiguration.class, SecureStampConfiguration.class})
public class WebServiceConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(WebServiceConfiguration.class);

    public WebServiceConfiguration(PlatformProperties platformProperties, EndpointProperties endpointProperties, ServerProperties serverProperties) {
        ServiceContextHolderBuilder.builder().endpointProperties(endpointProperties).platformProperties(platformProperties).serverProperties(serverProperties).build();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Web Service] Configure.");
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        ServiceContextHolder.setApplicationContext((ApplicationContext)applicationContext);
        ServiceContextHolder.setApplicationName((String)WebPropertyFinder.getApplicationName((ApplicationContext)applicationContext));
        log.debug("[Herodotus] |- HERODOTUS ApplicationContext initialization completed.");
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssObjectMapperBuilderCustomizer() {
        Jackson2XssObjectMapperBuilderCustomizer customizer = new Jackson2XssObjectMapperBuilderCustomizer();
        log.debug("[Herodotus] |- Strategy [Jackson2 Xss ObjectMapper Builder Customizer] Configure.");
        return customizer;
    }

    @Bean
    public ErrorCodeMapperBuilderCustomizer webErrorCodeMapperBuilderCustomizer() {
        WebErrorCodeMapperBuilderCustomizer customizer = new WebErrorCodeMapperBuilderCustomizer();
        log.debug("[Herodotus] |- Strategy [Web ErrorCodeMapper Builder Customizer] Configure.");
        return customizer;
    }
}

