/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.web.api.servlet;

import cn.herodotus.engine.core.definition.domain.BaseEntity;
import cn.herodotus.engine.core.definition.domain.Result;
import cn.herodotus.engine.data.core.service.BasePageService;
import cn.herodotus.engine.web.api.servlet.PageController;
import cn.herodotus.engine.web.core.annotation.AccessLimited;
import cn.herodotus.engine.web.core.definition.dto.Pager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

@SecurityRequirement(name="HERODOTUS_AUTH")
public abstract class AbstractReadableController<E extends BaseEntity, ID extends Serializable, S extends BasePageService<E, ID>>
implements PageController<E, ID, S> {
    @AccessLimited
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u6570\u636e", description="\u901a\u8fc7pageNumber\u548cpageSize\u83b7\u53d6\u5206\u9875\u6570\u636e", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pager", required=true, in=ParameterIn.QUERY, description="\u5206\u9875Bo\u5bf9\u8c61", schema=@Schema(implementation=Pager.class))})
    @GetMapping
    public Result<Map<String, Object>> findByPage(@Validated Pager pager) {
        if (ArrayUtils.isNotEmpty((Object[])pager.getProperties())) {
            Sort.Direction direction = Sort.Direction.valueOf((String)pager.getDirection());
            return PageController.super.findByPage(pager.getPageNumber(), pager.getPageSize(), direction, pager.getProperties());
        }
        return PageController.super.findByPage(pager.getPageNumber(), pager.getPageSize());
    }
}

