/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysElement;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysElementRepository;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SysElementService
extends BaseService<SysElement, String> {
    private final SysElementRepository sysElementRepository;

    public SysElementService(SysElementRepository sysElementRepository) {
        this.sysElementRepository = sysElementRepository;
    }

    public BaseRepository<SysElement, String> getRepository() {
        return this.sysElementRepository;
    }

    public Page<SysElement> findByCondition(int pageNumber, int pageSize, String path, String title) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (ObjectUtils.isNotEmpty((Object)path)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("path"), this.like(path)));
            }
            if (ObjectUtils.isNotEmpty((Object)title)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("title"), this.like(title)));
            }
            Predicate[] predicateArray = new Predicate[predicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(predicates.toArray(predicateArray)));
            return criteriaQuery.getRestriction();
        };
        return this.findByPage(specification, (Pageable)pageable);
    }

    public SysElement assign(String elementId, String[] roles) {
        HashSet<SysRole> sysRoles = new HashSet<SysRole>();
        for (String role : roles) {
            SysRole sysRole = new SysRole();
            sysRole.setRoleId(role);
            sysRoles.add(sysRole);
        }
        SysElement sysElement = (SysElement)this.findById((Serializable)((Object)elementId));
        sysElement.setRoles(sysRoles);
        return (SysElement)this.saveAndFlush((Entity)sysElement);
    }
}

