/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.hr;

import cn.herodotus.engine.assistant.core.exception.transaction.TransactionalRollbackException;
import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysDepartment;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysEmployee;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysOwnership;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysUser;
import cn.herodotus.engine.supplier.upms.logic.enums.Gender;
import cn.herodotus.engine.supplier.upms.logic.enums.Identity;
import cn.herodotus.engine.supplier.upms.logic.repository.hr.SysEmployeeRepository;
import cn.herodotus.engine.supplier.upms.logic.service.hr.SysOwnershipService;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysUserService;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysEmployeeService
extends BaseService<SysEmployee, String> {
    private static final Logger log = LoggerFactory.getLogger(SysEmployeeService.class);
    private final SysEmployeeRepository sysEmployeeRepository;
    private final SysOwnershipService sysOwnershipService;
    private final SysUserService sysUserService;

    public SysEmployeeService(SysEmployeeRepository sysEmployeeRepository, SysOwnershipService sysOwnershipService, SysUserService sysUserService) {
        this.sysEmployeeRepository = sysEmployeeRepository;
        this.sysOwnershipService = sysOwnershipService;
        this.sysUserService = sysUserService;
    }

    public BaseRepository<SysEmployee, String> getRepository() {
        return this.sysEmployeeRepository;
    }

    public Page<SysEmployee> findByCondition(int pageNumber, int pageSize, String employeeName, String mobilePhoneNumber, String officePhoneNumber, String email, String pkiEmail, Gender gender, Identity identity) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)employeeName)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("employeeName"), this.like(employeeName)));
            }
            if (StringUtils.isNotBlank((CharSequence)mobilePhoneNumber)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("mobilePhoneNumber"), this.like(mobilePhoneNumber)));
            }
            if (StringUtils.isNotBlank((CharSequence)officePhoneNumber)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("officePhoneNumber"), this.like(officePhoneNumber)));
            }
            if (StringUtils.isNotBlank((CharSequence)email)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("email"), this.like(email)));
            }
            if (StringUtils.isNotBlank((CharSequence)pkiEmail)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("pkiEmail"), this.like(pkiEmail)));
            }
            if (ObjectUtils.isNotEmpty((Object)((Object)gender))) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("gender"), (Object)gender));
            }
            if (ObjectUtils.isNotEmpty((Object)((Object)identity))) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("identity"), (Object)identity));
            }
            Predicate[] predicateArray = new Predicate[predicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(predicates.toArray(predicateArray)));
            return criteriaQuery.getRestriction();
        };
        return this.findByPage(specification, (Pageable)pageable);
    }

    public Page<SysEmployee> findAllocatable(int pageNumber, int pageSize, String organizationId, String departmentId, String employeeName, String mobilePhoneNumber, String email, Gender gender, Identity identity) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Subquery subQuery = criteriaQuery.subquery(SysOwnership.class);
            Root subRoot = subQuery.from(SysOwnership.class);
            ArrayList<Predicate> subPredicates = new ArrayList<Predicate>();
            subPredicates.add(criteriaBuilder.equal((Expression)subRoot.get("employeeId"), (Expression)root.get("employeeId")));
            if (StringUtils.isNotBlank((CharSequence)organizationId)) {
                subPredicates.add(criteriaBuilder.equal((Expression)subRoot.get("organizationId"), (Object)organizationId));
            }
            if (StringUtils.isNotBlank((CharSequence)departmentId)) {
                subPredicates.add(criteriaBuilder.equal((Expression)subRoot.get("departmentId"), (Object)departmentId));
            }
            Predicate[] subPredicateArray = new Predicate[subPredicates.size()];
            subQuery.where((Expression)criteriaBuilder.and(subPredicates.toArray(subPredicateArray)));
            subQuery.select((Expression)subRoot.get("ownershipId"));
            ArrayList<Predicate> rootPredicates = new ArrayList<Predicate>();
            rootPredicates.add(criteriaBuilder.not((Expression)criteriaBuilder.exists(subQuery)));
            if (StringUtils.isNotBlank((CharSequence)employeeName)) {
                rootPredicates.add(criteriaBuilder.like((Expression)root.get("employeeName"), this.like(employeeName)));
            }
            if (StringUtils.isNotBlank((CharSequence)mobilePhoneNumber)) {
                rootPredicates.add(criteriaBuilder.like((Expression)root.get("mobilePhoneNumber"), this.like(mobilePhoneNumber)));
            }
            if (StringUtils.isNotBlank((CharSequence)email)) {
                rootPredicates.add(criteriaBuilder.like((Expression)root.get("email"), this.like(email)));
            }
            if (ObjectUtils.isNotEmpty((Object)((Object)gender))) {
                rootPredicates.add(criteriaBuilder.equal((Expression)root.get("gender"), (Object)gender));
            }
            if (ObjectUtils.isNotEmpty((Object)((Object)identity))) {
                rootPredicates.add(criteriaBuilder.equal((Expression)root.get("identity"), (Object)identity));
            }
            Predicate[] rootPredicateArray = new Predicate[rootPredicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(rootPredicates.toArray(rootPredicateArray)));
            return criteriaQuery.getRestriction();
        };
        return this.findByPage(specification, (Pageable)pageable);
    }

    public Page<SysEmployee> findByDepartmentId(int pageNumber, int pageSize, String departmentId) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Join join = root.join("departments", JoinType.LEFT);
            return criteriaBuilder.equal((Expression)join.get("departmentId"), (Object)departmentId);
        };
        return this.findByPage(specification, (Pageable)pageable);
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public SysEmployee authorize(String employeeId) {
        SysEmployee sysEmployee = (SysEmployee)this.findById((Serializable)((Object)employeeId));
        SysUser sysUser = this.sysUserService.register(sysEmployee);
        if (ObjectUtils.isNotEmpty((Object)((Object)sysUser)) && ObjectUtils.isNotEmpty((Object)((Object)sysEmployee))) {
            sysUser.setEmployee(sysEmployee);
            SysUser newUser = (SysUser)this.sysUserService.saveAndFlush((Entity)sysUser);
            if (ObjectUtils.isNotEmpty((Object)((Object)newUser))) {
                return newUser.getEmployee();
            }
        }
        return null;
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public void deleteById(String employeeId) {
        this.sysOwnershipService.deleteByEmployeeId(employeeId);
        super.deleteById((Serializable)((Object)employeeId));
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public boolean deployAllocatable(List<SysEmployee> sysEmployees, List<SysOwnership> sysOwnerships) {
        List result;
        if (CollectionUtils.isNotEmpty(sysEmployees) && CollectionUtils.isNotEmpty(sysOwnerships) && CollectionUtils.isNotEmpty((Collection)(result = this.sysEmployeeRepository.saveAllAndFlush(sysEmployees)))) {
            this.sysOwnershipService.saveAll(sysOwnerships);
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={TransactionalRollbackException.class})
    public boolean removeAllocatable(String organizationId, String departmentId, String employeeId) {
        SysEmployee sysEmployee = (SysEmployee)super.findById((Serializable)((Object)employeeId));
        if (ObjectUtils.isNotEmpty((Object)((Object)sysEmployee))) {
            SysDepartment sysDepartment = new SysDepartment();
            sysDepartment.setDepartmentId(departmentId);
            sysEmployee.getDepartments().remove((Object)sysDepartment);
            SysEmployee result = (SysEmployee)super.save((Entity)sysEmployee);
            if (ObjectUtils.isNotEmpty((Object)((Object)result))) {
                this.sysOwnershipService.delete(organizationId, departmentId, employeeId);
                return true;
            }
        }
        return false;
    }

    public SysEmployee findByEmployeeName(String employeeName) {
        return this.sysEmployeeRepository.findByEmployeeName(employeeName);
    }
}

