/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.processor;

import cn.herodotus.engine.access.all.processor.AccessHandlerStrategyFactory;
import cn.herodotus.engine.access.core.definition.AccessUserDetails;
import cn.herodotus.engine.access.core.exception.AccessIdentityVerificationFailedException;
import cn.herodotus.engine.assistant.definition.domain.base.Entity;
import cn.herodotus.engine.assistant.definition.domain.oauth2.AccessPrincipal;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.engine.oauth2.core.definition.domain.SocialUserDetails;
import cn.herodotus.engine.oauth2.core.definition.handler.AbstractSocialAuthenticationHandler;
import cn.herodotus.engine.oauth2.core.exception.SocialCredentialsParameterBindingFailedException;
import cn.herodotus.engine.oauth2.core.exception.UsernameAlreadyExistsException;
import cn.herodotus.engine.supplier.upms.logic.converter.SysUserToHerodotusUserConverter;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysSocialUser;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysUser;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysSocialUserService;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysUserService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.bean.BeanUtil;
import org.springframework.core.convert.converter.Converter;

public class DefaultSocialAuthenticationHandler
extends AbstractSocialAuthenticationHandler {
    private final SysUserService sysUserService;
    private final SysSocialUserService sysSocialUserService;
    private final AccessHandlerStrategyFactory accessHandlerStrategyFactory;
    private final Converter<SysUser, HerodotusUser> toUser;

    public DefaultSocialAuthenticationHandler(SysUserService sysUserService, SysSocialUserService sysSocialUserService, AccessHandlerStrategyFactory accessHandlerStrategyFactory) {
        this.sysUserService = sysUserService;
        this.sysSocialUserService = sysSocialUserService;
        this.accessHandlerStrategyFactory = accessHandlerStrategyFactory;
        this.toUser = new SysUserToHerodotusUserConverter();
    }

    public SocialUserDetails identity(String source, AccessPrincipal accessPrincipal) throws AccessIdentityVerificationFailedException {
        AccessUserDetails accessUserDetails = this.accessHandlerStrategyFactory.findAccessUserDetails(source, accessPrincipal);
        if (BeanUtil.isNotEmpty((Object)accessUserDetails, (String[])new String[0])) {
            SysSocialUser sysSocialUser = new SysSocialUser();
            BeanUtil.copyProperties((Object)accessUserDetails, (Object)((Object)sysSocialUser), (String[])new String[0]);
            return sysSocialUser;
        }
        throw new AccessIdentityVerificationFailedException("Access Identity Verification Failed!");
    }

    public SocialUserDetails isUserExist(SocialUserDetails socialUserDetails) {
        String uuid = socialUserDetails.getUuid();
        String source = socialUserDetails.getSource();
        if (StringUtils.isNotBlank((CharSequence)uuid) && StringUtils.isNotBlank((CharSequence)source)) {
            return this.sysSocialUserService.findByUuidAndSource(uuid, source);
        }
        return null;
    }

    public HerodotusUser register(SocialUserDetails socialUserDetails) throws UsernameAlreadyExistsException {
        return this.sysUserService.registerUserDetails(socialUserDetails);
    }

    public void binding(String userId, SocialUserDetails socialUserDetails) throws SocialCredentialsParameterBindingFailedException {
        if (socialUserDetails instanceof SysSocialUser) {
            SysSocialUser sysSocialUser = (SysSocialUser)socialUserDetails;
            SysUser sysUser = new SysUser();
            sysUser.setUserId(userId);
            sysSocialUser.setUsers((Set<SysUser>)ImmutableSet.builder().add((Object)sysUser).build());
            this.sysSocialUserService.saveAndFlush((Entity)sysSocialUser);
        }
    }

    public void additionalRegisterOperation(HerodotusUser herodotusUserDetails, SocialUserDetails socialUserDetails) {
    }

    public HerodotusUser signIn(SocialUserDetails socialUserDetails) {
        if (socialUserDetails instanceof SysSocialUser) {
            SysSocialUser sysSocialUser = (SysSocialUser)socialUserDetails;
            SysUser sysUser = sysSocialUser.getUsers().stream().findFirst().orElse(null);
            if (ObjectUtils.isNotEmpty((Object)((Object)sysUser))) {
                return (HerodotusUser)this.toUser.convert((Object)sysUser);
            }
            return null;
        }
        return null;
    }

    public void additionalSignInOperation(HerodotusUser herodotusUserDetails, SocialUserDetails newSocialUserDetails, SocialUserDetails oldSocialUserDetails) {
        if (newSocialUserDetails instanceof SysSocialUser) {
            SysSocialUser newSysSocialUser = (SysSocialUser)newSocialUserDetails;
            if (oldSocialUserDetails instanceof SysSocialUser) {
                SysSocialUser oldSysSocialUser = (SysSocialUser)oldSocialUserDetails;
                this.setSocialUserInfo(oldSysSocialUser, newSysSocialUser.getAccessToken(), newSysSocialUser.getExpireIn(), newSysSocialUser.getRefreshToken(), newSysSocialUser.getRefreshTokenExpireIn(), newSysSocialUser.getScope(), newSysSocialUser.getTokenType(), newSysSocialUser.getUid(), newSysSocialUser.getOpenId(), newSysSocialUser.getAccessCode(), newSysSocialUser.getUnionId());
                this.sysSocialUserService.saveAndFlush((Entity)oldSysSocialUser);
            }
        }
    }

    protected void setSocialUserInfo(SysSocialUser sysSocialUser, String accessToken, Integer expireIn, String refreshToken, Integer refreshTokenExpireIn, String scope, String tokenType, String uid, String openId, String accessCode, String unionId) {
        sysSocialUser.setAccessToken(accessToken);
        sysSocialUser.setExpireIn(expireIn);
        sysSocialUser.setRefreshToken(refreshToken);
        sysSocialUser.setRefreshTokenExpireIn(refreshTokenExpireIn);
        sysSocialUser.setScope(scope);
        sysSocialUser.setTokenType(tokenType);
        sysSocialUser.setUid(uid);
        sysSocialUser.setOpenId(openId);
        sysSocialUser.setAccessCode(accessCode);
        sysSocialUser.setUnionId(unionId);
    }
}

