/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.configuration;

import cn.herodotus.engine.access.all.configuration.AccessAllConfiguration;
import cn.herodotus.engine.access.all.processor.AccessHandlerStrategyFactory;
import cn.herodotus.engine.oauth2.core.definition.handler.SocialAuthenticationHandler;
import cn.herodotus.engine.supplier.upms.logic.processor.DefaultSocialAuthenticationHandler;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysSocialUserService;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysUserService;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration(proxyBeanMethods=false)
@EntityScan(basePackages={"cn.herodotus.engine.supplier.upms.logic.entity.security", "cn.herodotus.engine.supplier.upms.logic.entity.hr"})
@EnableJpaRepositories(basePackages={"cn.herodotus.engine.supplier.upms.logic.repository.security", "cn.herodotus.engine.supplier.upms.logic.repository.hr"})
@ComponentScan(basePackages={"cn.herodotus.engine.supplier.upms.logic.service.security", "cn.herodotus.engine.supplier.upms.logic.service.hr", "cn.herodotus.engine.supplier.upms.logic.service.assistant"})
@Import(value={AccessAllConfiguration.class})
public class SupplierUpmsLogicConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SupplierUpmsLogicConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Supplier Upms Logic] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public SocialAuthenticationHandler socialAuthenticationHandler(SysUserService sysUserService, SysSocialUserService sysSocialUserService, AccessHandlerStrategyFactory accessHandlerStrategyFactory) {
        DefaultSocialAuthenticationHandler defaultSocialAuthenticationHandler = new DefaultSocialAuthenticationHandler(sysUserService, sysSocialUserService, accessHandlerStrategyFactory);
        log.trace("[Herodotus] |- Bean [Default Social Authentication Handler] Auto Configure.");
        return defaultSocialAuthenticationHandler;
    }
}

