/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.entity.hr;

import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.oauth2.core.definition.domain.SocialUserDetails;
import cn.herodotus.engine.supplier.upms.logic.domain.deserializer.SysUserEmptyToNull;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysDepartment;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysUser;
import cn.herodotus.engine.supplier.upms.logic.enums.Gender;
import cn.herodotus.engine.supplier.upms.logic.enums.Identity;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Schema(title="\u4eba\u5458")
@Entity
@NamedEntityGraph(name="SysEmployeeWithSysUser.Graph", attributeNodes={@NamedAttributeNode(value="user", subgraph="SysUser.SubGraph")}, subgraphs={@NamedSubgraph(name="SysUser.SubGraph", attributeNodes={@NamedAttributeNode(value="userId")})})
@Table(name="sys_employee", indexes={@Index(name="sys_employee_id_idx", columnList="employee_id")})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="employeeId")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:employee")
public class SysEmployee
extends BaseSysEntity
implements SocialUserDetails {
    @Schema(title="\u4eba\u5458ID")
    @Id
    @UuidGenerator
    @Column(name="employee_id", length=64)
    private String employeeId;
    @Schema(title="\u59d3\u540d")
    @Column(name="employee_name", length=50)
    private String employeeName;
    @Schema(title="\u5de5\u53f7")
    @Column(name="employee_no", length=50)
    private String employeeNo;
    @Schema(title="\u624b\u673a\u53f7\u7801")
    @Column(name="mobile_phone_number", length=50)
    private String mobilePhoneNumber;
    @Schema(title="\u529e\u516c\u7535\u8bdd")
    @Column(name="office_phone_number", length=50)
    private String officePhoneNumber;
    @Schema(title="\u7535\u5b50\u90ae\u7bb1")
    @Column(name="email", length=100)
    private String email;
    @Schema(title="PKI\u7535\u5b50\u90ae\u7bb1")
    @Column(name="pki_email", length=100)
    private String pkiEmail;
    @Schema(title="4A\u6807\u51c6\u4eba\u5458ID")
    @Column(name="a4_biz_emp_id", length=256)
    private String a4BizEmpId;
    @Schema(title="\u5934\u50cf")
    @Column(name="avatar", length=1000)
    private String avatar;
    @Schema(title="\u751f\u65e5")
    @Column(name="birth_day")
    @Temporal(value=TemporalType.DATE)
    private Date birthday;
    @Schema(title="\u6027\u522b")
    @Column(name="gender")
    @Enumerated(value=EnumType.ORDINAL)
    private Gender gender = Gender.MAN;
    @Schema(title="\u8eab\u4efd")
    @Column(name="identity")
    @Enumerated(value=EnumType.ORDINAL)
    private Identity identity = Identity.STAFF;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:department")
    @ManyToMany
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="sys_employee_department", joinColumns={@JoinColumn(name="employee_id")}, inverseJoinColumns={@JoinColumn(name="department_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"employee_id", "department_id"})}, indexes={@Index(name="sys_employee_department_eid_idx", columnList="employee_id"), @Index(name="sys_employee_department_did_idx", columnList="department_id")})
    private Set<SysDepartment> departments = new HashSet<SysDepartment>();
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:user")
    @JsonDeserialize(using=SysUserEmptyToNull.class)
    @OneToOne(mappedBy="employee", cascade={CascadeType.ALL})
    private SysUser user;

    public SysUser getUser() {
        return this.user;
    }

    public void setUser(SysUser user) {
        this.user = user;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeNo() {
        return this.employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public String getOfficePhoneNumber() {
        return this.officePhoneNumber;
    }

    public void setOfficePhoneNumber(String officePhoneNumber) {
        this.officePhoneNumber = officePhoneNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPkiEmail() {
        return this.pkiEmail;
    }

    public void setPkiEmail(String pkiEmail) {
        this.pkiEmail = pkiEmail;
    }

    public String getA4BizEmpId() {
        return this.a4BizEmpId;
    }

    public void setA4BizEmpId(String a4BizEmpId) {
        this.a4BizEmpId = a4BizEmpId;
    }

    public String getUuid() {
        return this.employeeId;
    }

    public String getSource() {
        return AccountType.INSTITUTION.getKey();
    }

    public String getPhoneNumber() {
        return this.getMobilePhoneNumber();
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUsername() {
        return this.getEmployeeName();
    }

    public String getNickname() {
        return this.getEmail();
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Set<SysDepartment> getDepartments() {
        return this.departments;
    }

    public void setDepartments(Set<SysDepartment> departments) {
        this.departments = departments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SysEmployee that = (SysEmployee)((Object)o);
        return new EqualsBuilder().append((Object)this.getEmployeeId(), (Object)that.getEmployeeId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getEmployeeId()).toHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("employeeId", (Object)this.employeeId).add("employeeName", (Object)this.employeeName).add("employeeNo", (Object)this.employeeNo).add("mobilePhoneNumber", (Object)this.mobilePhoneNumber).add("officePhoneNumber", (Object)this.officePhoneNumber).add("email", (Object)this.email).add("pkiEmail", (Object)this.pkiEmail).add("a4BizEmpId", (Object)this.a4BizEmpId).add("avatar", (Object)this.avatar).add("birthday", (Object)this.birthday).add("gender", (Object)this.gender).add("identity", (Object)this.identity).toString();
    }
}

