/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysPermission;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysRoleRepository;
import java.io.Serializable;
import java.util.HashSet;
import org.springframework.stereotype.Service;

@Service
public class SysRoleService
extends BaseService<SysRole, String> {
    private final SysRoleRepository sysRoleRepository;

    public SysRoleService(SysRoleRepository sysRoleRepository) {
        this.sysRoleRepository = sysRoleRepository;
    }

    public BaseRepository<SysRole, String> getRepository() {
        return this.sysRoleRepository;
    }

    public SysRole assign(String roleId, String[] permissions) {
        HashSet<SysPermission> sysPermissions = new HashSet<SysPermission>();
        for (String permission : permissions) {
            SysPermission sysPermission = new SysPermission();
            sysPermission.setPermissionId(permission);
            sysPermissions.add(sysPermission);
        }
        SysRole sysRole = (SysRole)this.findById((Serializable)((Object)roleId));
        sysRole.setPermissions(sysPermissions);
        return (SysRole)this.saveAndFlush((Entity)sysRole);
    }

    public SysRole findByRoleCode(String roleCode) {
        return this.sysRoleRepository.findByRoleCode(roleCode);
    }

    public SysRole findByRoleId(String roleId) {
        return this.sysRoleRepository.findByRoleId(roleId);
    }
}

