/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysAttribute;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysPermission;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysAttributeRepository;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysAttributeService
extends BaseService<SysAttribute, String> {
    private final SysAttributeRepository sysAttributeRepository;

    public SysAttributeService(SysAttributeRepository sysAttributeRepository) {
        this.sysAttributeRepository = sysAttributeRepository;
    }

    public BaseRepository<SysAttribute, String> getRepository() {
        return this.sysAttributeRepository;
    }

    public SysAttribute assign(String attributeId, String[] permissionIds) {
        HashSet<SysPermission> sysPermissions = new HashSet<SysPermission>();
        for (String permissionId : permissionIds) {
            SysPermission sysPermission = new SysPermission();
            sysPermission.setPermissionId(permissionId);
            sysPermissions.add(sysPermission);
        }
        SysAttribute sysAttribute = (SysAttribute)this.findById((Serializable)((Object)attributeId));
        sysAttribute.setPermissions(sysPermissions);
        return (SysAttribute)this.saveAndFlush((Entity)sysAttribute);
    }

    public List<SysAttribute> findAllByServiceId(String serviceId) {
        return this.sysAttributeRepository.findAllByServiceId(serviceId);
    }

    public List<SysAttribute> findByAttributeIdIn(List<String> ids) {
        return this.sysAttributeRepository.findByAttributeIdIn(ids);
    }
}

