/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.converter;

import cn.herodotus.engine.assistant.core.utils.WellFormedUtils;
import cn.herodotus.engine.assistant.core.view.vue.BaseMeta;
import cn.herodotus.engine.assistant.core.view.vue.ChildMeta;
import cn.herodotus.engine.assistant.core.view.vue.ParentMeta;
import cn.herodotus.engine.assistant.core.view.vue.RootMeta;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysElement;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.tree.TreeNode;
import org.springframework.core.convert.converter.Converter;

public class SysElementToTreeNodeConverter
implements Converter<SysElement, TreeNode<String>> {
    public TreeNode<String> convert(SysElement sysMenu) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId((Object)sysMenu.getElementId());
        treeNode.setName((CharSequence)sysMenu.getPath());
        treeNode.setWeight((Comparable)sysMenu.getRanking());
        treeNode.setParentId((Object)WellFormedUtils.parentId((String)sysMenu.getParentId()));
        treeNode.setExtra(this.getExtra(sysMenu));
        return treeNode;
    }

    private Map<String, Object> getExtra(SysElement sysMenu) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)sysMenu.getParentId())) {
            meta = new RootMeta();
            meta.setSort(sysMenu.getRanking());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("redirect", sysMenu.getRedirect());
        } else if (BooleanUtils.isTrue((Boolean)sysMenu.getHaveChild())) {
            meta = new ParentMeta();
            meta.setHideAllChild(sysMenu.getHideAllChild());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        } else {
            meta = new ChildMeta();
            meta.setDetailContent(sysMenu.getDetailContent());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        }
        extra.put("componentPath", sysMenu.getComponent());
        Set<SysRole> sysRoles = sysMenu.getRoles();
        if (CollectionUtils.isNotEmpty(sysRoles)) {
            List roles = sysRoles.stream().map(SysRole::getRoleCode).collect(Collectors.toList());
            extra.put("roles", roles);
        } else {
            extra.put("roles", new ArrayList());
        }
        return extra;
    }

    private void setBaseMeta(SysElement sysMenu, BaseMeta meta) {
        meta.setIcon(sysMenu.getIcon());
        meta.setTitle(sysMenu.getTitle());
        meta.setIgnoreAuth(sysMenu.getIgnoreAuth());
        meta.setNotKeepAlive(sysMenu.getNotKeepAlive());
    }
}

