/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.entity.security;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.supplier.upms.logic.domain.deserializer.SysEmployeeEmptyToNull;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysEmployee;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Schema(title="\u7cfb\u7edf\u7528\u6237")
@Entity
@Table(name="sys_user", uniqueConstraints={@UniqueConstraint(columnNames={"user_name"})}, indexes={@Index(name="sys_user_id_idx", columnList="user_id"), @Index(name="sys_user_unm_idx", columnList="user_name")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:user")
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="userId")
public class SysUser
extends BaseSysEntity {
    @Schema(title="\u7528\u6237ID")
    @Id
    @UuidGenerator
    @Column(name="user_id", length=64)
    private String userId;
    @Schema(title="\u7528\u6237\u540d")
    @Column(name="user_name", length=128, unique=true)
    private String userName;
    @Schema(title="\u5bc6\u7801", description="BCryptPasswordEncoder")
    @Column(name="password", length=256)
    private String password;
    @Schema(title="\u6635\u79f0")
    @Column(name="nick_name", length=64)
    private String nickName;
    @Schema(title="\u624b\u673a\u53f7\u7801")
    @Column(name="phone_number", length=256)
    private String phoneNumber;
    @Schema(title="\u5934\u50cf")
    @Column(name="avatar", length=1024)
    private String avatar;
    @Schema(title="EMAIL")
    @Column(name="email", length=100)
    private String email;
    @Schema(title="\u8d26\u6237\u8fc7\u671f\u65e5\u671f")
    @Column(name="account_expire_at")
    private LocalDateTime accountExpireAt;
    @Schema(title="\u5bc6\u7801\u8fc7\u671f\u65e5\u671f")
    @Column(name="credentials_expire_at")
    private LocalDateTime credentialsExpireAt;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:role")
    @Schema(title="\u7528\u6237\u89d2\u8272")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="sys_user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "role_id"})}, indexes={@Index(name="sys_user_role_uid_idx", columnList="user_id"), @Index(name="sys_user_role_rid_idx", columnList="role_id")})
    private Set<SysRole> roles = new HashSet<SysRole>();
    @JsonDeserialize(using=SysEmployeeEmptyToNull.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:employee")
    @Schema(title="\u4eba\u5458")
    @OneToOne(fetch=FetchType.LAZY)
    @JoinTable(name="sys_user_employee", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="employee_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "employee_id"})}, indexes={@Index(name="sys_user_employee_sid_idx", columnList="user_id"), @Index(name="sys_user_employee_eid_idx", columnList="employee_id")})
    private SysEmployee employee;

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Set<SysRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<SysRole> roles) {
        this.roles = roles;
    }

    public SysEmployee getEmployee() {
        return this.employee;
    }

    public void setEmployee(SysEmployee employee) {
        this.employee = employee;
    }

    public LocalDateTime getAccountExpireAt() {
        return this.accountExpireAt;
    }

    public void setAccountExpireAt(LocalDateTime accountExpireAt) {
        this.accountExpireAt = accountExpireAt;
    }

    public LocalDateTime getCredentialsExpireAt() {
        return this.credentialsExpireAt;
    }

    public void setCredentialsExpireAt(LocalDateTime credentialsExpireAt) {
        this.credentialsExpireAt = credentialsExpireAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("userId", (Object)this.userId).add("userName", (Object)this.userName).add("password", (Object)this.password).add("nickName", (Object)this.nickName).add("phoneNumber", (Object)this.phoneNumber).add("avatar", (Object)this.avatar).add("email", (Object)this.email).toString();
    }
}

