/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.converter;

import cn.herodotus.engine.data.core.enums.DataItemStatus;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusGrantedAuthority;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.engine.oauth2.core.utils.SecurityUtils;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysPermission;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysUser;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class SysUserToHerodotusUserConverter
implements Converter<SysUser, HerodotusUser> {
    public HerodotusUser convert(SysUser sysUser) {
        HashSet<HerodotusGrantedAuthority> authorities = new HashSet<HerodotusGrantedAuthority>();
        HashSet<String> roles = new HashSet<String>();
        for (SysRole sysRole : sysUser.getRoles()) {
            roles.add(sysRole.getRoleCode());
            authorities.add(new HerodotusGrantedAuthority(SecurityUtils.wellFormRolePrefix((String)sysRole.getRoleCode())));
            Set<SysPermission> sysPermissions = sysRole.getPermissions();
            if (!CollectionUtils.isNotEmpty(sysPermissions)) continue;
            sysPermissions.forEach(sysAuthority -> authorities.add(new HerodotusGrantedAuthority(sysAuthority.getPermissionCode())));
        }
        String employeeId = ObjectUtils.isNotEmpty((Object)((Object)sysUser.getEmployee())) ? sysUser.getEmployee().getEmployeeId() : null;
        return new HerodotusUser(sysUser.getUserId(), sysUser.getUserName(), sysUser.getPassword(), this.isEnabled(sysUser), this.isAccountNonExpired(sysUser), this.isCredentialsNonExpired(sysUser), this.isNonLocked(sysUser), authorities, roles, employeeId, sysUser.getAvatar());
    }

    private boolean isEnabled(SysUser sysUser) {
        return sysUser.getStatus() != DataItemStatus.FORBIDDEN;
    }

    private boolean isNonLocked(SysUser sysUser) {
        return sysUser.getStatus() != DataItemStatus.LOCKING;
    }

    private boolean isNonExpired(LocalDateTime localDateTime) {
        if (ObjectUtils.isEmpty((Object)localDateTime)) {
            return true;
        }
        return localDateTime.isAfter(LocalDateTime.now());
    }

    private boolean isAccountNonExpired(SysUser sysUser) {
        if (sysUser.getStatus() == DataItemStatus.EXPIRED) {
            return false;
        }
        return this.isNonExpired(sysUser.getAccountExpireAt());
    }

    private boolean isCredentialsNonExpired(SysUser sysUser) {
        return this.isNonExpired(sysUser.getCredentialsExpireAt());
    }
}

