/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.rest.core.domain.RequestMapping;
import cn.herodotus.engine.supplier.upms.logic.converter.RequestMappingToSysInterfaceConverter;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysAttribute;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysInterface;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysInterfaceRepository;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SysInterfaceService
extends BaseService<SysInterface, String> {
    private final SysInterfaceRepository sysInterfaceRepository;
    private final Converter<RequestMapping, SysInterface> toSysInterface;

    public SysInterfaceService(SysInterfaceRepository sysInterfaceRepository) {
        this.sysInterfaceRepository = sysInterfaceRepository;
        this.toSysInterface = new RequestMappingToSysInterfaceConverter();
    }

    public BaseRepository<SysInterface, String> getRepository() {
        return this.sysInterfaceRepository;
    }

    public List<SysInterface> findAllocatable() {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Subquery subQuery = criteriaQuery.subquery(SysAttribute.class);
            Root subRoot = subQuery.from(SysAttribute.class);
            Predicate subPredicate = criteriaBuilder.equal((Expression)subRoot.get("attributeId"), (Expression)root.get("interfaceId"));
            subQuery.where((Expression)subPredicate);
            subQuery.select((Expression)subRoot.get("attributeId"));
            criteriaQuery.where((Expression)criteriaBuilder.not((Expression)criteriaBuilder.exists(subQuery)));
            return criteriaQuery.getRestriction();
        };
        return this.findAll(specification);
    }

    public List<SysInterface> storeRequestMappings(Collection<RequestMapping> requestMappings) {
        List<SysInterface> sysAuthorities = this.toSysInterfaces(requestMappings);
        return this.saveAllAndFlush(sysAuthorities);
    }

    private List<SysInterface> toSysInterfaces(Collection<RequestMapping> requestMappings) {
        if (CollectionUtils.isNotEmpty(requestMappings)) {
            return requestMappings.stream().map(arg_0 -> this.toSysInterface.convert(arg_0)).collect(Collectors.toList());
        }
        return new ArrayList<SysInterface>();
    }
}

