/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.data.core.enums.DataItemStatus;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.oauth2.core.definition.domain.HerodotusUser;
import cn.herodotus.engine.oauth2.core.definition.domain.SocialUserDetails;
import cn.herodotus.engine.oauth2.core.utils.SecurityUtils;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysDefaultRole;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysUser;
import cn.herodotus.engine.supplier.upms.logic.helper.UpmsHelper;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysUserRepository;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysDefaultRoleService;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.data.id.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysUserService
extends BaseService<SysUser, String> {
    private static final Logger log = LoggerFactory.getLogger(SysUserService.class);
    private final SysUserRepository sysUserRepository;
    private final SysDefaultRoleService sysDefaultRoleService;

    public SysUserService(SysUserRepository sysUserRepository, SysDefaultRoleService sysDefaultRoleService) {
        this.sysUserRepository = sysUserRepository;
        this.sysDefaultRoleService = sysDefaultRoleService;
    }

    public BaseRepository<SysUser, String> getRepository() {
        return this.sysUserRepository;
    }

    public SysUser findByUserName(String userName) {
        return this.sysUserRepository.findByUserName(userName);
    }

    public SysUser findByUserId(String userId) {
        return this.sysUserRepository.findByUserId(userId);
    }

    public SysUser changePassword(String userId, String password) {
        SysUser sysUser = this.findByUserId(userId);
        sysUser.setPassword(SecurityUtils.encrypt((String)password));
        return (SysUser)this.saveAndFlush((Entity)sysUser);
    }

    public SysUser assign(String userId, String[] roleIds) {
        SysUser sysUser = this.findByUserId(userId);
        return this.register(sysUser, roleIds);
    }

    public SysUser register(SysUser sysUser, String[] roleIds) {
        HashSet<SysRole> sysRoles = new HashSet<SysRole>();
        for (String roleId : roleIds) {
            SysRole sysRole = new SysRole();
            sysRole.setRoleId(roleId);
            sysRoles.add(sysRole);
        }
        return this.register(sysUser, sysRoles);
    }

    public SysUser register(SysUser sysUser, AccountType source) {
        SysRole sysRole;
        SysDefaultRole sysDefaultRole = this.sysDefaultRoleService.findByScene(source);
        if (ObjectUtils.isNotEmpty((Object)((Object)sysDefaultRole)) && ObjectUtils.isNotEmpty((Object)((Object)(sysRole = sysDefaultRole.getRole())))) {
            return this.register(sysUser, sysRole);
        }
        log.error("[Herodotus] |- Default role for [{}] is not set correct, may case register error!", (Object)source);
        return null;
    }

    public SysUser register(SysUser sysUser, SysRole sysRole) {
        HashSet<SysRole> sysRoles = new HashSet<SysRole>();
        sysRoles.add(sysRole);
        return this.register(sysUser, sysRoles);
    }

    public SysUser register(SysUser sysUser, Set<SysRole> sysRoles) {
        if (CollectionUtils.isNotEmpty(sysRoles)) {
            sysUser.setRoles(sysRoles);
        }
        return (SysUser)this.saveAndFlush((Entity)sysUser);
    }

    private String enhance(String userName) {
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            SysUser checkedSysUser = this.findByUserName(userName);
            if (ObjectUtils.isNotEmpty((Object)((Object)checkedSysUser))) {
                return checkedSysUser.getUserName() + IdUtil.nanoId((int)6);
            }
            return userName;
        }
        return "Herodotus" + IdUtil.nanoId((int)6);
    }

    public SysUser register(SocialUserDetails socialUserDetails) {
        String avatar;
        String phoneNumber;
        SysUser sysUser = new SysUser();
        String userName = this.enhance(socialUserDetails.getUserName());
        sysUser.setUserName(userName);
        String nickName = socialUserDetails.getNickName();
        if (StringUtils.isNotBlank((CharSequence)nickName)) {
            sysUser.setNickName(nickName);
        }
        if (StringUtils.isNotBlank((CharSequence)(phoneNumber = socialUserDetails.getPhoneNumber()))) {
            sysUser.setPhoneNumber(SecurityUtils.encrypt((String)phoneNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(avatar = socialUserDetails.getAvatar()))) {
            sysUser.setAvatar(avatar);
        }
        sysUser.setPassword(SecurityUtils.encrypt((String)"herodotus-cloud"));
        return this.register(sysUser, AccountType.getAccountType((String)socialUserDetails.getSource()));
    }

    public HerodotusUser registerUserDetails(SocialUserDetails socialUserDetails) {
        SysUser newSysUser = this.register(socialUserDetails);
        return UpmsHelper.convertSysUserToHerodotusUser(newSysUser);
    }

    public void changeStatus(String userId, DataItemStatus status) {
        SysUser sysUser = this.findByUserId(userId);
        if (ObjectUtils.isNotEmpty((Object)((Object)sysUser))) {
            sysUser.setStatus(status);
            log.debug("[Herodotus] |- Change user [{}] status to [{}]", (Object)sysUser.getUserName(), (Object)status.name());
            this.save((Entity)sysUser);
        }
    }
}

