/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.entity.security;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="sys_element", indexes={@Index(name="sys_element_id_idx", columnList="element_id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:element")
public class SysElement
extends BaseSysEntity {
    @Id
    @UuidGenerator
    @Column(name="element_id", length=64)
    private String elementId;
    @Column(name="parent_id", length=64)
    private String parentId;
    @Column(name="path", length=512)
    private String path;
    @Column(name="name", length=50)
    private String name;
    @Column(name="component", length=512)
    private String component;
    @Column(name="redirect", length=512)
    private String redirect;
    @Column(name="title", length=100)
    private String title;
    @Column(name="type", length=50)
    private String type;
    @Column(name="icon", length=100)
    private String icon;
    @JsonProperty(value="isHaveChild")
    @Column(name="have_child")
    private Boolean haveChild = false;
    @JsonProperty(value="isNotKeepAlive")
    @Column(name="not_keep_alive")
    private Boolean notKeepAlive = false;
    @JsonProperty(value="isHideAllChild")
    @Column(name="hide_all_child")
    private Boolean hideAllChild = false;
    @JsonProperty(value="isDetailContent")
    @Column(name="detail_content")
    private Boolean detailContent = false;
    @JsonProperty(value="isIgnoreAuth")
    @Column(name="ignore_auth")
    private Boolean ignoreAuth = false;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:role")
    @Schema(title="\u5143\u7d20\u89d2\u8272")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="sys_element_role", joinColumns={@JoinColumn(name="element_id")}, inverseJoinColumns={@JoinColumn(name="role_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"element_id", "role_id"})}, indexes={@Index(name="sys_element_role_eid_idx", columnList="element_id"), @Index(name="sys_element_role_rid_idx", columnList="role_id")})
    private Set<SysRole> roles = new HashSet<SysRole>();

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Boolean getHaveChild() {
        return this.haveChild;
    }

    public void setHaveChild(Boolean haveChild) {
        this.haveChild = haveChild;
    }

    public Boolean getNotKeepAlive() {
        return this.notKeepAlive;
    }

    public void setNotKeepAlive(Boolean notKeepAlive) {
        this.notKeepAlive = notKeepAlive;
    }

    public Boolean getHideAllChild() {
        return this.hideAllChild;
    }

    public void setHideAllChild(Boolean hideAllChild) {
        this.hideAllChild = hideAllChild;
    }

    public Boolean getDetailContent() {
        return this.detailContent;
    }

    public void setDetailContent(Boolean detailContent) {
        this.detailContent = detailContent;
    }

    public Boolean getIgnoreAuth() {
        return this.ignoreAuth;
    }

    public void setIgnoreAuth(Boolean ignoreAuth) {
        this.ignoreAuth = ignoreAuth;
    }

    public Set<SysRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<SysRole> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SysElement sysMenu = (SysElement)((Object)o);
        return Objects.equal((Object)this.elementId, (Object)sysMenu.elementId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.elementId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("elementId", (Object)this.elementId).add("parentId", (Object)this.parentId).add("path", (Object)this.path).add("name", (Object)this.name).add("component", (Object)this.component).add("redirect", (Object)this.redirect).add("title", (Object)this.title).add("type", (Object)this.type).add("icon", (Object)this.icon).add("haveChild", (Object)this.haveChild).add("notKeepAlive", (Object)this.notKeepAlive).add("hideAllChild", (Object)this.hideAllChild).add("detailContent", (Object)this.detailContent).add("ignoreAuth", (Object)this.ignoreAuth).add("roles", this.roles).toString();
    }
}

