/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.rest.core.domain.RequestMapping;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysAttribute;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysInterface;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysInterfaceRepository;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SysInterfaceService
extends BaseService<SysInterface, String> {
    private static final Logger log = LoggerFactory.getLogger(SysInterfaceService.class);
    private final SysInterfaceRepository sysInterfaceRepository;

    public SysInterfaceService(SysInterfaceRepository sysInterfaceRepository) {
        this.sysInterfaceRepository = sysInterfaceRepository;
    }

    public BaseRepository<SysInterface, String> getRepository() {
        return this.sysInterfaceRepository;
    }

    public List<SysInterface> findAllocatable() {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Subquery subQuery = criteriaQuery.subquery(SysAttribute.class);
            Root subRoot = subQuery.from(SysAttribute.class);
            Predicate subPredicate = criteriaBuilder.equal((Expression)subRoot.get("attributeId"), (Expression)root.get("interfaceId"));
            subQuery.where((Expression)subPredicate);
            subQuery.select((Expression)subRoot.get("attributeId"));
            criteriaQuery.where((Expression)criteriaBuilder.not((Expression)criteriaBuilder.exists(subQuery)));
            return criteriaQuery.getRestriction();
        };
        log.debug("[Herodotus] |- SysInterface Service findAllocatable.");
        return this.findAll(specification);
    }

    public List<SysInterface> batchSaveOrUpdate(List<SysInterface> domains) {
        List interfaces = this.sysInterfaceRepository.saveAllAndFlush(domains);
        log.debug("[Herodotus] |- SysInterface Service batchSaveOrUpdate.");
        return interfaces;
    }

    public List<SysInterface> storeRequestMappings(Collection<RequestMapping> requestMappings) {
        List<SysInterface> sysAuthorities = this.toSysInterfaces(requestMappings);
        return this.batchSaveOrUpdate(sysAuthorities);
    }

    private List<SysInterface> toSysInterfaces(Collection<RequestMapping> requestMappings) {
        if (CollectionUtils.isNotEmpty(requestMappings)) {
            return requestMappings.stream().map(this::toSysInterface).collect(Collectors.toList());
        }
        return new ArrayList<SysInterface>();
    }

    private SysInterface toSysInterface(RequestMapping requestMapping) {
        SysInterface sysInterface = new SysInterface();
        sysInterface.setInterfaceId(requestMapping.getMappingId());
        sysInterface.setInterfaceCode(requestMapping.getMappingCode());
        sysInterface.setRequestMethod(requestMapping.getRequestMethod());
        sysInterface.setServiceId(requestMapping.getServiceId());
        sysInterface.setClassName(requestMapping.getClassName());
        sysInterface.setMethodName(requestMapping.getMethodName());
        sysInterface.setUrl(requestMapping.getUrl());
        sysInterface.setDescription(requestMapping.getDescription());
        return sysInterface;
    }
}

