/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.core.enums.AccountType;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysDefaultRole;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysDefaultRoleRepository;
import cn.herodotus.engine.supplier.upms.logic.service.security.SysRoleService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDefaultRoleService
extends BaseService<SysDefaultRole, String> {
    private static final Logger log = LoggerFactory.getLogger(SysDefaultRoleService.class);
    private final SysDefaultRoleRepository sysDefaultRoleRepository;
    private final SysRoleService sysRoleService;

    @Autowired
    public SysDefaultRoleService(SysDefaultRoleRepository sysDefaultRoleRepository, SysRoleService sysRoleService) {
        this.sysDefaultRoleRepository = sysDefaultRoleRepository;
        this.sysRoleService = sysRoleService;
    }

    public BaseRepository<SysDefaultRole, String> getRepository() {
        return this.sysDefaultRoleRepository;
    }

    public SysDefaultRole findByScene(AccountType scene) {
        SysDefaultRole sysDefaultRole = this.sysDefaultRoleRepository.findByScene(scene);
        log.debug("[Herodotus] |- SysDefaultRole Service findBySource.");
        return sysDefaultRole;
    }

    public SysDefaultRole assign(String defaultId, String roleId) {
        SysRole sysRole = this.sysRoleService.findByRoleId(roleId);
        SysDefaultRole sysDefaultRole = this.sysDefaultRoleRepository.findByDefaultId(defaultId);
        if (ObjectUtils.isNotEmpty((Object)((Object)sysDefaultRole)) && ObjectUtils.isNotEmpty((Object)((Object)sysRole))) {
            sysDefaultRole.setRole(sysRole);
            return (SysDefaultRole)((Object)this.sysDefaultRoleRepository.saveAndFlush((Object)sysDefaultRole));
        }
        return null;
    }
}

