/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.hr;

import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.hr.SysDepartment;
import cn.herodotus.engine.supplier.upms.logic.repository.hr.SysDepartmentRepository;
import cn.herodotus.engine.supplier.upms.logic.service.hr.SysOwnershipService;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SysDepartmentService
extends BaseService<SysDepartment, String> {
    private static final Logger log = LoggerFactory.getLogger(SysDepartmentService.class);
    private final SysDepartmentRepository sysDepartmentRepository;
    private final SysOwnershipService sysOwnershipService;

    @Autowired
    public SysDepartmentService(SysDepartmentRepository sysDepartmentRepository, SysOwnershipService sysOwnershipService) {
        this.sysDepartmentRepository = sysDepartmentRepository;
        this.sysOwnershipService = sysOwnershipService;
    }

    public BaseRepository<SysDepartment, String> getRepository() {
        return this.sysDepartmentRepository;
    }

    public Page<SysDepartment> findByCondition(int pageNumber, int pageSize, String organizationId) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (ObjectUtils.isNotEmpty((Object)organizationId)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("organizationId"), (Object)organizationId));
            }
            Predicate[] predicateArray = new Predicate[predicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(predicates.toArray(predicateArray)));
            return criteriaQuery.getRestriction();
        };
        log.debug("[Herodotus] |- SysDepartment Service findByCondition.");
        return this.findByPage(specification, (Pageable)pageable);
    }

    public List<SysDepartment> findAll(String organizationId) {
        if (ObjectUtils.isNotEmpty((Object)organizationId)) {
            return this.sysDepartmentRepository.findByOrganizationId(organizationId);
        }
        return this.sysDepartmentRepository.findAll();
    }

    public void deleteById(String departmentId) {
        this.sysOwnershipService.deleteByDepartmentId(departmentId);
        super.deleteById((Serializable)((Object)departmentId));
        log.debug("[Herodotus] |- SysDepartment Service deleteById.");
    }
}

