/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.entity.security;

import cn.herodotus.engine.data.core.entity.BaseSysEntity;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysPermission;
import com.google.common.base.MoreObjects;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="sys_role", uniqueConstraints={@UniqueConstraint(columnNames={"role_code"})}, indexes={@Index(name="sys_role_rid_idx", columnList="role_id"), @Index(name="sys_role_rcd_idx", columnList="role_code")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:role")
public class SysRole
extends BaseSysEntity {
    @Id
    @UuidGenerator
    @Column(name="role_id", length=64)
    private String roleId;
    @Column(name="role_code", length=128, unique=true)
    private String roleCode;
    @Column(name="role_name", length=128)
    private String roleName;
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:upms:sys:permission")
    @ManyToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="sys_role_permission", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "permission_id"})}, indexes={@Index(name="sys_role_permission_rid_idx", columnList="role_id"), @Index(name="sys_role_permission_pid_idx", columnList="permission_id")})
    private Set<SysPermission> permissions = new HashSet<SysPermission>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Set<SysPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<SysPermission> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SysRole sysRole = (SysRole)((Object)o);
        return new EqualsBuilder().append((Object)this.getRoleId(), (Object)sysRole.getRoleId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getRoleId()).toHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("roleId", (Object)this.roleId).add("roleCode", (Object)this.roleCode).add("roleName", (Object)this.roleName).toString();
    }
}

