/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysPermission;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysRoleRepository;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleService
extends BaseService<SysRole, String> {
    private static final Logger log = LoggerFactory.getLogger(SysRoleService.class);
    private final SysRoleRepository sysRoleRepository;

    @Autowired
    public SysRoleService(SysRoleRepository sysRoleRepository) {
        this.sysRoleRepository = sysRoleRepository;
    }

    public BaseRepository<SysRole, String> getRepository() {
        return this.sysRoleRepository;
    }

    public SysRole assign(String roleId, String[] permissions) {
        HashSet<SysPermission> sysPermissions = new HashSet<SysPermission>();
        for (String permission : permissions) {
            SysPermission sysPermission = new SysPermission();
            sysPermission.setPermissionId(permission);
            sysPermissions.add(sysPermission);
        }
        SysRole sysRole = (SysRole)this.findById((Serializable)((Object)roleId));
        sysRole.setPermissions(sysPermissions);
        log.debug("[Herodotus] |- SysRole Service authorize.");
        return (SysRole)this.saveOrUpdate((Entity)sysRole);
    }

    public SysRole findByRoleCode(String roleCode) {
        SysRole sysRole = this.sysRoleRepository.findByRoleCode(roleCode);
        log.debug("[Herodotus] |- SysRole Service findByRoleCode.");
        return sysRole;
    }

    public SysRole findByRoleId(String roleId) {
        SysRole sysRole = this.sysRoleRepository.findByRoleId(roleId);
        log.debug("[Herodotus] |- SysRole Service findByRoleId.");
        return sysRole;
    }
}

