/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.supplier.upms.logic.service.security;

import cn.herodotus.engine.assistant.core.component.router.BaseMeta;
import cn.herodotus.engine.assistant.core.component.router.ChildMeta;
import cn.herodotus.engine.assistant.core.component.router.ParentMeta;
import cn.herodotus.engine.assistant.core.component.router.RootMeta;
import cn.herodotus.engine.assistant.core.definition.domain.Entity;
import cn.herodotus.engine.data.core.repository.BaseRepository;
import cn.herodotus.engine.data.core.service.BaseService;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysElement;
import cn.herodotus.engine.supplier.upms.logic.entity.security.SysRole;
import cn.herodotus.engine.supplier.upms.logic.repository.security.SysElementRepository;
import cn.hutool.core.lang.tree.TreeNode;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SysElementService
extends BaseService<SysElement, String> {
    private static final Logger log = LoggerFactory.getLogger(SysElementService.class);
    private final SysElementRepository sysElementRepository;

    @Autowired
    public SysElementService(SysElementRepository sysElementRepository) {
        this.sysElementRepository = sysElementRepository;
    }

    public BaseRepository<SysElement, String> getRepository() {
        return this.sysElementRepository;
    }

    public Page<SysElement> findByCondition(int pageNumber, int pageSize, String path, String title) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (ObjectUtils.isNotEmpty((Object)path)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("path"), this.like(path)));
            }
            if (ObjectUtils.isNotEmpty((Object)title)) {
                predicates.add(criteriaBuilder.like((Expression)root.get("title"), this.like(title)));
            }
            Predicate[] predicateArray = new Predicate[predicates.size()];
            criteriaQuery.where((Expression)criteriaBuilder.and(predicates.toArray(predicateArray)));
            return criteriaQuery.getRestriction();
        };
        log.debug("[Herodotus] |- SysElementService Service findByCondition.");
        return this.findByPage(specification, (Pageable)pageable);
    }

    public SysElement assign(String elementId, String[] roles) {
        HashSet<SysRole> sysRoles = new HashSet<SysRole>();
        for (String role : roles) {
            SysRole sysRole = new SysRole();
            sysRole.setRoleId(role);
            sysRoles.add(sysRole);
        }
        SysElement sysElement = (SysElement)this.findById((Serializable)((Object)elementId));
        sysElement.setRoles(sysRoles);
        log.debug("[Herodotus] |- SysElementService Service authorize.");
        return (SysElement)this.saveOrUpdate((Entity)sysElement);
    }

    private String convertParentId(String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return "0";
        }
        return parentId;
    }

    private void setBaseMeta(SysElement sysMenu, BaseMeta meta) {
        meta.setIcon(sysMenu.getIcon());
        meta.setTitle(sysMenu.getTitle());
        meta.setIgnoreAuth(sysMenu.getIgnoreAuth());
        meta.setNotKeepAlive(sysMenu.getNotKeepAlive());
    }

    private Map<String, Object> getExtra(SysElement sysMenu) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)sysMenu.getParentId())) {
            meta = new RootMeta();
            meta.setSort(sysMenu.getRanking());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("redirect", sysMenu.getRedirect());
        } else if (BooleanUtils.isTrue((Boolean)sysMenu.getHaveChild())) {
            meta = new ParentMeta();
            meta.setHideAllChild(sysMenu.getHideAllChild());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        } else {
            meta = new ChildMeta();
            meta.setDetailContent(sysMenu.getDetailContent());
            this.setBaseMeta(sysMenu, (BaseMeta)meta);
            extra.put("meta", meta);
            extra.put("componentName", sysMenu.getName());
        }
        extra.put("componentPath", sysMenu.getComponent());
        Set<SysRole> sysRoles = sysMenu.getRoles();
        if (CollectionUtils.isNotEmpty(sysRoles)) {
            List roles = sysRoles.stream().map(SysRole::getRoleCode).collect(Collectors.toList());
            extra.put("roles", roles);
        } else {
            extra.put("roles", new ArrayList());
        }
        return extra;
    }

    public TreeNode<String> convertToTreeNode(SysElement sysMenu) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId((Object)sysMenu.getElementId());
        treeNode.setName((CharSequence)sysMenu.getPath());
        treeNode.setWeight((Comparable)sysMenu.getRanking());
        treeNode.setParentId((Object)this.convertParentId(sysMenu.getParentId()));
        treeNode.setExtra(this.getExtra(sysMenu));
        return treeNode;
    }
}

