/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.autoconfigure;

import cn.herodotus.engine.sms.aliyun.configuration.AliyunSmsConfiguration;
import cn.herodotus.engine.sms.autoconfigure.annotation.ConditionalOnSmsEnabled;
import cn.herodotus.engine.sms.autoconfigure.processor.SmsSendStrategyFactory;
import cn.herodotus.engine.sms.autoconfigure.properties.SmsProperties;
import cn.herodotus.engine.sms.autoconfigure.stamp.VerificationCodeStampManager;
import cn.herodotus.engine.sms.chinamobile.configuration.ChinaMobileSmsConfiguration;
import cn.herodotus.engine.sms.core.definition.SmsSendHandler;
import cn.herodotus.engine.sms.huawei.configuration.HuaweiSmsConfiguration;
import cn.herodotus.engine.sms.jd.configuration.JdSmsConfiguration;
import cn.herodotus.engine.sms.netease.configuration.NeteaseSmsConfiguration;
import cn.herodotus.engine.sms.qiniu.configuration.QiniuSmsConfiguration;
import cn.herodotus.engine.sms.tencent.configuration.TencentSmsConfiguration;
import cn.herodotus.engine.sms.upyun.configuration.UpyunSmsConfiguration;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnSmsEnabled
@EnableConfigurationProperties(value={SmsProperties.class})
@Import(value={AliyunSmsConfiguration.class, ChinaMobileSmsConfiguration.class, HuaweiSmsConfiguration.class, JdSmsConfiguration.class, NeteaseSmsConfiguration.class, QiniuSmsConfiguration.class, TencentSmsConfiguration.class, UpyunSmsConfiguration.class})
public class SmsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SmsAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Sms All] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public VerificationCodeStampManager verificationCodeStampManager(SmsProperties smsProperties) {
        VerificationCodeStampManager verificationCodeStampManager = new VerificationCodeStampManager();
        verificationCodeStampManager.setSmsProperties(smsProperties);
        log.trace("[Herodotus] |- Bean [Verification Code Stamp Manager] Auto Configure.");
        return verificationCodeStampManager;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSingleCandidate(value=SmsSendHandler.class)
    public SmsSendStrategyFactory smsSendStrategyFactory(SmsProperties smsProperties) {
        SmsSendStrategyFactory smsSendStrategyFactory = new SmsSendStrategyFactory();
        smsSendStrategyFactory.setSmsProperties(smsProperties);
        log.trace("[Herodotus] |- Bean [Sms Send Strategy Factory] Auto Configure.");
        return smsSendStrategyFactory;
    }
}

