/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.autoconfigure.processor;

import cn.herodotus.engine.sms.autoconfigure.properties.SmsProperties;
import cn.herodotus.engine.sms.core.definition.SmsSendHandler;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsSendStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SmsSendStrategyFactory.class);
    @Autowired
    private final Map<String, SmsSendHandler> handlers = new ConcurrentHashMap<String, SmsSendHandler>();
    private SmsProperties smsProperties;

    public void setSmsProperties(SmsProperties smsProperties) {
        this.smsProperties = smsProperties;
    }

    public boolean send(Template template, String phone) {
        SmsSupplier smsSupplier = this.smsProperties.getDefaultChannel();
        if (ObjectUtils.isNotEmpty((Object)smsSupplier)) {
            return this.send(smsSupplier.name(), template, phone);
        }
        log.error("[Herodotus] |- Default sms channel is not correct!");
        return false;
    }

    public boolean send(Template template, List<String> phones) {
        SmsSupplier smsSupplier = this.smsProperties.getDefaultChannel();
        if (ObjectUtils.isNotEmpty((Object)smsSupplier)) {
            return this.send(smsSupplier.name(), template, phones);
        }
        log.error("[Herodotus] |- Default sms channel is not correct!");
        return false;
    }

    public boolean send(String channel, Template template, String phone) {
        SmsSendHandler handler = this.handlers.get(channel);
        if (ObjectUtils.isNotEmpty((Object)handler)) {
            return handler.send(template, (List)ImmutableList.of((Object)phone));
        }
        log.error("[Herodotus] |- Sms channel [{}] is not config!", (Object)channel);
        return false;
    }

    public boolean send(String channel, Template template, List<String> phones) {
        SmsSendHandler handler = this.handlers.get(channel);
        if (ObjectUtils.isNotEmpty((Object)handler)) {
            return handler.send(template, phones);
        }
        log.error("[Herodotus] |- Sms channel [{}] is not config!", (Object)channel);
        return false;
    }
}

