/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.yunpian.configuration;

import cn.herodotus.engine.sms.yunpian.annotation.ConditionalOnYunpianSmsEnabled;
import cn.herodotus.engine.sms.yunpian.processor.YunpianSmsSendHandler;
import cn.herodotus.engine.sms.yunpian.properties.YunpianSmsProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnYunpianSmsEnabled
@EnableConfigurationProperties(value={YunpianSmsProperties.class})
public class YunpianSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YunpianSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Sms Yunpian] Auto Configure.");
    }

    @Bean(name={"YUNPIAN"})
    public YunpianSmsSendHandler yunpianSmsSendHandler(YunpianSmsProperties yunpianSmsProperties) {
        YunpianSmsSendHandler handler = new YunpianSmsSendHandler(yunpianSmsProperties);
        log.debug("[Herodotus] |- Bean [Yunpian Sms Send Handler] Auto Configure.");
        return handler;
    }
}

