/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.tencent.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.definition.SmsProperties;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.tencent.properties.TencentSmsProperties;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TencentSmsSendHandler
extends AbstractSmsSendHandler {
    private static final String SUCCESS_CODE = "OK";
    private final SmsClient sender;
    private final TencentSmsProperties properties;

    public TencentSmsSendHandler(TencentSmsProperties properties) {
        super((SmsProperties)properties);
        this.properties = properties;
        Credential credential = new Credential(this.properties.getSecretId(), this.properties.getSecretKey());
        this.sender = new SmsClient(credential, this.properties.getRegion());
    }

    protected String getChannel() {
        return SmsSupplier.TENCENT_CLOUD.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        List groups = CollUtil.split(phones, (int)200);
        String templateId = this.getTemplateId(template);
        List templateParams = this.getOrderedParams(template);
        List errors = groups.parallelStream().map(group -> this.send(templateId, (List<String>)group, templateParams)).collect(Collectors.toList());
        ArrayList result = new ArrayList();
        if (CollectionUtils.isNotEmpty(errors)) {
            for (List subErrors : errors) {
                result.addAll(subErrors);
            }
        }
        return CollectionUtils.isEmpty(result);
    }

    private List<String> send(String templateId, List<String> mobileGroup, List<String> templateParams) {
        try {
            SendSmsRequest request = new SendSmsRequest();
            request.setSmsSdkAppid(this.properties.getSmsAppId());
            request.setSign(this.properties.getSmsSign());
            request.setTemplateID(templateId);
            request.setTemplateParamSet((String[])ArrayUtil.toArray(templateParams, String.class));
            request.setPhoneNumberSet((String[])ArrayUtil.toArray(mobileGroup, String.class));
            SendSmsResponse sendSmsResponse = this.sender.SendSms(request);
            if (ArrayUtil.isEmpty((Object[])sendSmsResponse.getSendStatusSet())) {
                return mobileGroup;
            }
            SendStatus[] sendStatuses = sendSmsResponse.getSendStatusSet();
            return Arrays.stream(sendStatuses).filter(sendStatus -> !sendStatus.getCode().equals(SUCCESS_CODE)).map(SendStatus::getPhoneNumber).collect(Collectors.toList());
        }
        catch (TencentCloudSDKException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }
}

