/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.tencent.configuration;

import cn.herodotus.engine.sms.tencent.annotation.ConditionalOnTencentSmsEnabled;
import cn.herodotus.engine.sms.tencent.processor.TencentSmsSendHandler;
import cn.herodotus.engine.sms.tencent.properties.TencentSmsProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnTencentSmsEnabled
@EnableConfigurationProperties(value={TencentSmsProperties.class})
public class TencentSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Sms Tencent] Auto Configure.");
    }

    @Bean(name={"TENCENT"})
    public TencentSmsSendHandler tencentCloudSmsSendHandler(TencentSmsProperties tencentSmsProperties) {
        TencentSmsSendHandler tencentSmsSendHandler = new TencentSmsSendHandler(tencentSmsProperties);
        log.debug("[Herodotus] |- Bean [Tencent Sms Send Handler] Auto Configure.");
        return tencentSmsSendHandler;
    }
}

