/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.netease.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsProperties;
import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.netease.domain.NeteaseSmsResponse;
import cn.herodotus.engine.sms.netease.processor.CheckSumBuilder;
import cn.herodotus.engine.sms.netease.properties.NeteaseSmsProperties;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.SHttpTask;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeteaseSmsSendHandler
extends AbstractSmsSendHandler<NeteaseSmsProperties> {
    private static final Logger log = LoggerFactory.getLogger(NeteaseSmsSendHandler.class);

    public NeteaseSmsSendHandler(NeteaseSmsProperties neteaseSmsProperties) {
        super((AbstractSmsProperties)neteaseSmsProperties);
    }

    protected String getChannel() {
        return SmsSupplier.NETEASE_CLOUD.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        String templateId = this.getTemplateId(template);
        String templateParams = this.getOrderedParamsString(template);
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        String nonce = RandomUtil.randomString((int)6);
        String checkSum = CheckSumBuilder.getCheckSum(((NeteaseSmsProperties)this.getSmsProperties()).getAppSecret(), nonce, curTime);
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)this.http().sync(((NeteaseSmsProperties)this.getSmsProperties()).getApiUrl()).bodyType("form")).addHeader("AppKey", ((NeteaseSmsProperties)this.getSmsProperties()).getAppKey())).addHeader("CurTime", curTime)).addHeader("CheckSum", checkSum)).addHeader("Nonce", nonce)).addBodyPara("templateid", (Object)templateId)).addBodyPara("mobiles", (Object)this.join(phones))).addBodyPara("params", (Object)templateParams)).nothrow()).post();
        if (result.isSuccessful()) {
            NeteaseSmsResponse neteaseSmsResponse = (NeteaseSmsResponse)result.getBody().toBean(NeteaseSmsResponse.class);
            return ObjectUtils.isNotEmpty((Object)neteaseSmsResponse) && NeteaseSmsResponse.SUCCESS_CODE.equals(neteaseSmsResponse.getCode());
        }
        return false;
    }
}

