/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.netease.configuration;

import cn.herodotus.engine.sms.netease.annotation.ConditionalOnNeteaseSmsEnabled;
import cn.herodotus.engine.sms.netease.processor.NeteaseSmsSendHandler;
import cn.herodotus.engine.sms.netease.properties.NeteaseSmsProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnNeteaseSmsEnabled
@EnableConfigurationProperties(value={NeteaseSmsProperties.class})
public class NeteaseSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NeteaseSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Sms Netease] Auto Configure.");
    }

    @Bean(name={"NETEASE"})
    public NeteaseSmsSendHandler neteaseCloudSmsSendHandler(NeteaseSmsProperties neteaseSmsProperties) {
        NeteaseSmsSendHandler neteaseSmsSendHandler = new NeteaseSmsSendHandler(neteaseSmsProperties);
        log.debug("[Herodotus] |- Bean [Netease Sms Send Handler] Auto Configure.");
        return neteaseSmsSendHandler;
    }
}

