/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.netease.processor;

import java.security.MessageDigest;

public class CheckSumBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getCheckSum(String appSecret, String nonce, String curTime) {
        return CheckSumBuilder.encode("sha1", appSecret + nonce + curTime);
    }

    public static String getMd5(String requestBody) {
        return CheckSumBuilder.encode("md5", requestBody);
    }

    private static String encode(String algorithm, String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(value.getBytes());
            return CheckSumBuilder.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (byte aByte : bytes) {
            buf.append(HEX_DIGITS[aByte >> 4 & 0xF]);
            buf.append(HEX_DIGITS[aByte & 0xF]);
        }
        return buf.toString();
    }
}

