/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.jd.configuration;

import cn.herodotus.engine.sms.jd.annotation.ConditionalOnJdSmsEnabled;
import cn.herodotus.engine.sms.jd.processor.JdSmsSendHandler;
import cn.herodotus.engine.sms.jd.properties.JdSmsProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnJdSmsEnabled
@EnableConfigurationProperties(value={JdSmsProperties.class})
public class JdSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JdSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Sms Jd] Auto Configure.");
    }

    @Bean(name={"JD"})
    public JdSmsSendHandler jdCloudSmsSendHandler(JdSmsProperties jdSmsProperties) {
        JdSmsSendHandler jdSmsSendHandler = new JdSmsSendHandler(jdSmsProperties);
        log.debug("[Herodotus] |- Bean [Jd Sms Send Handler] Auto Configure.");
        return jdSmsSendHandler;
    }
}

