/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.huawei.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsProperties;
import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.huawei.domain.HuaweiSmsRequest;
import cn.herodotus.engine.sms.huawei.domain.HuaweiSmsResponse;
import cn.herodotus.engine.sms.huawei.properties.HuaweiSmsProperties;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.SHttpTask;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiSmsSendHandler
extends AbstractSmsSendHandler<HuaweiSmsProperties> {
    private static final Logger log = LoggerFactory.getLogger(HuaweiSmsSendHandler.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

    public HuaweiSmsSendHandler(HuaweiSmsProperties properties) {
        super((AbstractSmsProperties)properties);
    }

    private String buildWsseHeader() {
        String appKey = ((HuaweiSmsProperties)this.getSmsProperties()).getAppKey();
        String appSecret = ((HuaweiSmsProperties)this.getSmsProperties()).getAppSecret();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(ByteUtil.toUtf8Bytes((CharSequence)hexDigest));
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }

    protected String getChannel() {
        return SmsSupplier.HUAWEI_CLOUD.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        String templateId = this.getTemplateId(template);
        String mobiles = this.wellFormed(phones);
        String templateParams = this.getOrderedParamsString(template);
        String wsseHeader = this.buildWsseHeader();
        HuaweiSmsRequest request = new HuaweiSmsRequest();
        request.setFrom(((HuaweiSmsProperties)this.getSmsProperties()).getSender());
        request.setTo(mobiles);
        request.setTemplateId(templateId);
        request.setTemplateParas(templateParams);
        request.setSignature(((HuaweiSmsProperties)this.getSmsProperties()).getSignature());
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)this.http().sync(((HuaweiSmsProperties)this.getSmsProperties()).getUri()).bodyType("json")).addHeader("Authorization", AUTH_HEADER_VALUE)).addHeader("X-WSSE", wsseHeader)).setBodyPara((Object)request)).nothrow()).post();
        if (result.isSuccessful()) {
            HuaweiSmsResponse huaweiSmsResponse = (HuaweiSmsResponse)result.getBody().toBean(HuaweiSmsResponse.class);
            return ObjectUtils.isNotEmpty((Object)huaweiSmsResponse) && "000000".equals(huaweiSmsResponse.getCode());
        }
        return false;
    }
}

