/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.chinamobile.domain;

import org.apache.commons.codec.digest.DigestUtils;

public class ChinaMobileSmsRequest {
    private final String ecName;
    private final String apId;
    private final String templateId;
    private final String mobiles;
    private final String params;
    private final String sign;
    private final String addSerial;
    private final String mac;

    public ChinaMobileSmsRequest(String ecName, String apId, String secretKey, String templateId, String mobiles, String params, String sign) {
        this.ecName = ecName;
        this.apId = apId;
        this.templateId = templateId;
        this.mobiles = mobiles;
        this.params = params;
        this.sign = sign;
        this.addSerial = "";
        this.mac = this.generateMac(ecName, apId, secretKey, templateId, mobiles, params, sign);
    }

    private String generateMac(String ecName, String apId, String secretKey, String templateId, String mobiles, String params, String sign) {
        String origin = ecName + apId + secretKey + templateId + mobiles + params + sign;
        return DigestUtils.md5Hex((String)origin);
    }

    public String getEcName() {
        return this.ecName;
    }

    public String getApId() {
        return this.apId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getMobiles() {
        return this.mobiles;
    }

    public String getParams() {
        return this.params;
    }

    public String getSign() {
        return this.sign;
    }

    public String getAddSerial() {
        return this.addSerial;
    }

    public String getMac() {
        return this.mac;
    }
}

