/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.aliyun.processor;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.engine.sms.aliyun.properties.AliyunSmsProperties;
import cn.herodotus.engine.sms.core.definition.AbstractSmsProperties;
import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSmsSendHandler
extends AbstractSmsSendHandler<AliyunSmsProperties> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsSendHandler.class);
    private final IAcsClient iAcsClient;

    public AliyunSmsSendHandler(AliyunSmsProperties aliyunSmsProperties) {
        super((AbstractSmsProperties)aliyunSmsProperties);
        DefaultProfile profile = DefaultProfile.getProfile((String)aliyunSmsProperties.getRegionId(), (String)aliyunSmsProperties.getAccessKeyId(), (String)aliyunSmsProperties.getAccessKeySecret());
        DefaultProfile.addEndpoint((String)aliyunSmsProperties.getRegionId(), (String)aliyunSmsProperties.getProduct(), (String)aliyunSmsProperties.getDomain());
        this.iAcsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    protected String getChannel() {
        return SmsSupplier.ALIYUN.name();
    }

    public boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(((AliyunSmsProperties)this.getSmsProperties()).getDomain());
        request.setSysVersion(((AliyunSmsProperties)this.getSmsProperties()).getVersion());
        request.setSysAction(((AliyunSmsProperties)this.getSmsProperties()).getAction());
        request.putQueryParameter("PhoneNumbers", this.join(phones));
        request.putQueryParameter("SignName", ((AliyunSmsProperties)this.getSmsProperties()).getSignName());
        request.putQueryParameter("TemplateCode", this.getTemplateId(template));
        request.putQueryParameter("TemplateParam", Jackson2Utils.toJson((Object)template.getParams()));
        try {
            CommonResponse response = this.iAcsClient.getCommonResponse(request);
            return ObjectUtils.isNotEmpty((Object)response) && response.getHttpResponse().isSuccess();
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- [{}] Send Sms Catch Exception: {}", (Object)this.getChannel(), (Object)e.getMessage());
            return false;
        }
    }
}

