/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.aliyun.configuration;

import cn.herodotus.engine.sms.aliyun.annotation.ConditionalOnAliyunSmsEnabled;
import cn.herodotus.engine.sms.aliyun.processor.AliyunSmsSendHandler;
import cn.herodotus.engine.sms.aliyun.properties.AliyunSmsProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAliyunSmsEnabled
@EnableConfigurationProperties(value={AliyunSmsProperties.class})
public class AliyunSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Sms Aliyun] Auto Configure.");
    }

    @Bean(name={"ALIYUN"})
    public AliyunSmsSendHandler aliyunSmsSendHandler(AliyunSmsProperties aliyunSmsProperties) {
        AliyunSmsSendHandler aliyunSmsSendHandler = new AliyunSmsSendHandler(aliyunSmsProperties);
        log.debug("[Herodotus] |- Bean [Aliyun Sms Send Handler] Auto Configure.");
        return aliyunSmsSendHandler;
    }
}

