/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.aliyun.processor;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.JacksonUtils;
import cn.herodotus.engine.sms.aliyun.properties.AliyunSmsProperties;
import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.definition.SmsProperties;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSmsSendHandler
extends AbstractSmsSendHandler {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsSendHandler.class);
    private final IAcsClient iAcsClient;
    private final AliyunSmsProperties properties;

    public AliyunSmsSendHandler(AliyunSmsProperties properties) {
        super((SmsProperties)properties);
        this.properties = properties;
        DefaultProfile profile = DefaultProfile.getProfile((String)this.properties.getRegionId(), (String)this.properties.getAccessKeyId(), (String)this.properties.getAccessKeySecret());
        DefaultProfile.addEndpoint((String)this.properties.getRegionId(), (String)this.properties.getProduct(), (String)this.properties.getDomain());
        this.iAcsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    protected String getChannel() {
        return SmsSupplier.ALIYUN.name();
    }

    public boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(this.properties.getDomain());
        request.setSysVersion(this.properties.getVersion());
        request.setSysAction(this.properties.getAction());
        request.putQueryParameter("PhoneNumbers", this.join(phones));
        request.putQueryParameter("SignName", this.properties.getSignName());
        request.putQueryParameter("TemplateCode", this.getTemplateId(template));
        request.putQueryParameter("TemplateParam", JacksonUtils.toJson((Object)template.getParams()));
        try {
            CommonResponse response = this.iAcsClient.getCommonResponse(request);
            return ObjectUtils.isNotEmpty((Object)response) && response.getHttpResponse().isSuccess();
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- [{}] Send Sms Catch Exception: {}", (Object)this.getChannel(), (Object)e.getMessage());
            return false;
        }
    }
}

