/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.security.core.utils;

import cn.herodotus.engine.assistant.core.utils.BeanUtils;
import cn.herodotus.engine.security.core.definition.domain.HerodotusUserDetails;
import cn.hutool.core.bean.BeanUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String PREFIX_ROLE = "ROLE_";
    public static final String PREFIX_SCOPE = "SCOPE_";

    public static SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    public static Authentication getAuthentication() {
        return SecurityUtils.getSecurityContext().getAuthentication();
    }

    public static boolean isAuthenticated() {
        return ObjectUtils.isNotEmpty((Object)SecurityUtils.getAuthentication()) && SecurityUtils.getAuthentication().isAuthenticated();
    }

    public static Object getDetails() {
        return SecurityUtils.getAuthentication().getDetails();
    }

    public static void reloadAuthority(HerodotusUserDetails newHerodotusUserDetails) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)newHerodotusUserDetails, (Object)newHerodotusUserDetails.getPassword(), newHerodotusUserDetails.getAuthorities());
        token.setDetails(SecurityUtils.getDetails());
        SecurityUtils.getSecurityContext().setAuthentication((Authentication)token);
    }

    public static HerodotusUserDetails getPrincipal() {
        if (SecurityUtils.isAuthenticated()) {
            Authentication authentication = SecurityUtils.getAuthentication();
            if (authentication.getPrincipal() instanceof HerodotusUserDetails) {
                return (HerodotusUserDetails)authentication.getPrincipal();
            }
            if (authentication.getPrincipal() instanceof Map) {
                Map principal = (Map)authentication.getPrincipal();
                return (HerodotusUserDetails)BeanUtils.mapToBean((Map)principal, HerodotusUserDetails.class);
            }
        }
        return null;
    }

    public static String getUsername() {
        HerodotusUserDetails user = SecurityUtils.getPrincipal();
        if (user != null) {
            return user.getUsername();
        }
        return null;
    }

    public static HerodotusUserDetails getPrincipals() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal != null) {
            if (principal instanceof HerodotusUserDetails) {
                return (HerodotusUserDetails)principal;
            }
            if (principal instanceof LinkedHashMap) {
                HerodotusUserDetails user = new HerodotusUserDetails();
                BeanUtil.fillBeanWithMap((Map)((LinkedHashMap)principal), (Object)user, (boolean)true);
                return user;
            }
            if (principal instanceof String && principal.equals("anonymousUser")) {
                return null;
            }
            throw new IllegalStateException("\u83b7\u53d6\u7528\u6237\u6570\u636e\u5931\u8d25");
        }
        return null;
    }

    public static String getUserId() {
        HerodotusUserDetails herodotusUserDetails = SecurityUtils.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)herodotusUserDetails)) {
            return herodotusUserDetails.getUserId();
        }
        return null;
    }

    public static String getNickName() {
        HerodotusUserDetails herodotusUserDetails = SecurityUtils.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)herodotusUserDetails)) {
            return herodotusUserDetails.getNickName();
        }
        return null;
    }

    public static String getAvatar() {
        HerodotusUserDetails herodotusUserDetails = SecurityUtils.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)herodotusUserDetails)) {
            return herodotusUserDetails.getAvatar();
        }
        return null;
    }

    public static String encrypt(String password) {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        return encoder.encode((CharSequence)password);
    }

    public static boolean matches(String rawPassowrd, String encodedPassword) {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        return encoder.matches((CharSequence)rawPassowrd, encodedPassword);
    }

    public static String[] whitelistToAntMatchers(List<String> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            String[] array = new String[list.size()];
            log.debug("[Herodotus] |- Fetch The REST White List.");
            return list.toArray(array);
        }
        log.warn("[Herodotus] |- Can not Fetch The REST White List Configurations.");
        return new String[0];
    }

    public static String wellFormRolePrefix(String content) {
        return SecurityUtils.wellFormPrefix(content, PREFIX_ROLE);
    }

    public static String wellFormPrefix(String content, String prefix) {
        if (StringUtils.startsWith((CharSequence)content, (CharSequence)prefix)) {
            return content;
        }
        return prefix + content;
    }
}

