/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.security.core.properties;

import cn.herodotus.engine.security.core.enums.RoleSecurityStrategy;
import cn.herodotus.engine.security.core.enums.ScopeSecurityStrategy;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="herodotus.platform.security")
public class SecurityProperties
implements Serializable {
    private String signingKey = "herodotus-cloud";
    private String verifierKey = "herodotus-cloud";
    private Login login = new Login();
    private RememberMe rememberMe = new RememberMe();
    private Captcha captcha = new Captcha();
    private Interceptor interceptor = new Interceptor();

    public String getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(String signingKey) {
        this.signingKey = signingKey;
    }

    public String getVerifierKey() {
        return this.verifierKey;
    }

    public void setVerifierKey(String verifierKey) {
        this.verifierKey = verifierKey;
    }

    public Login getLogin() {
        return this.login;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public RememberMe getRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(RememberMe rememberMe) {
        this.rememberMe = rememberMe;
    }

    public Captcha getCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(Captcha captcha) {
        this.captcha = captcha;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static class Interceptor
    implements Serializable {
        private boolean openAuthorizationCheck = true;
        private List<String> whitelist = new ArrayList<String>();
        private List<String> staticResource = new ArrayList<String>();
        private RoleSecurityStrategy roleSecurityStrategy = RoleSecurityStrategy.ROLE_VOTER;
        private ScopeSecurityStrategy scopeSecurityStrategy = ScopeSecurityStrategy.SECURITY_EXPRESSION;

        public boolean isOpenAuthorizationCheck() {
            return this.openAuthorizationCheck;
        }

        public void setOpenAuthorizationCheck(boolean openAuthorizationCheck) {
            this.openAuthorizationCheck = openAuthorizationCheck;
        }

        public List<String> getWhitelist() {
            return this.whitelist;
        }

        public void setWhitelist(List<String> whitelist) {
            this.whitelist = whitelist;
        }

        public List<String> getStaticResource() {
            return this.staticResource;
        }

        public void setStaticResource(List<String> staticResource) {
            this.staticResource = staticResource;
        }

        public RoleSecurityStrategy getRoleSecurityStrategy() {
            return this.roleSecurityStrategy;
        }

        public void setRoleSecurityStrategy(RoleSecurityStrategy roleSecurityStrategy) {
            this.roleSecurityStrategy = roleSecurityStrategy;
        }

        public ScopeSecurityStrategy getScopeSecurityStrategy() {
            return this.scopeSecurityStrategy;
        }

        public void setScopeSecurityStrategy(ScopeSecurityStrategy scopeSecurityStrategy) {
            this.scopeSecurityStrategy = scopeSecurityStrategy;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("openAuthorizationCheck", this.openAuthorizationCheck).add("roleSecurityStrategy", (Object)this.roleSecurityStrategy).add("scopeSecurityStrategy", (Object)this.scopeSecurityStrategy).toString();
        }
    }

    public static class Captcha
    implements Serializable {
        private String sessionAttribute = "captcha";
        private boolean closed = false;
        private String captchaParameter = this.sessionAttribute;
        private String category = "HUTOOL_GIF";

        public String getSessionAttribute() {
            return this.sessionAttribute;
        }

        public void setSessionAttribute(String sessionAttribute) {
            this.sessionAttribute = sessionAttribute;
        }

        public String getCaptchaParameter() {
            return this.captchaParameter;
        }

        public void setCaptchaParameter(String captchaParameter) {
            this.captchaParameter = captchaParameter;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void setClosed(boolean closed) {
            this.closed = closed;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }

    public static class RememberMe
    implements Serializable {
        private String cookieName = "remember-me";
        private Integer validitySeconds = 3600;

        public String getCookieName() {
            return this.cookieName;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public Integer getValiditySeconds() {
            return this.validitySeconds;
        }

        public void setValiditySeconds(Integer validitySeconds) {
            this.validitySeconds = validitySeconds;
        }
    }

    public static class Login
    implements Serializable {
        private String usernameParameter = "username";
        private String passwordParameter = "password";
        private String loginUrl;
        private String loginProcessingUrl = this.loginUrl = "/login";
        private String defaultSuccessUrl = "/";
        private String successForwardUrl;
        private String failureUrl = this.loginUrl;
        private String failureForwardUrl;

        public String getUsernameParameter() {
            return this.usernameParameter;
        }

        public void setUsernameParameter(String usernameParameter) {
            this.usernameParameter = usernameParameter;
        }

        public String getPasswordParameter() {
            return this.passwordParameter;
        }

        public void setPasswordParameter(String passwordParameter) {
            this.passwordParameter = passwordParameter;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }

        public void setLoginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
        }

        public String getLoginProcessingUrl() {
            return this.loginProcessingUrl;
        }

        public void setLoginProcessingUrl(String loginProcessingUrl) {
            this.loginProcessingUrl = loginProcessingUrl;
        }

        public String getDefaultSuccessUrl() {
            return this.defaultSuccessUrl;
        }

        public void setDefaultSuccessUrl(String defaultSuccessUrl) {
            this.defaultSuccessUrl = defaultSuccessUrl;
        }

        public String getSuccessForwardUrl() {
            return this.successForwardUrl;
        }

        public void setSuccessForwardUrl(String successForwardUrl) {
            this.successForwardUrl = successForwardUrl;
        }

        public String getFailureUrl() {
            return this.failureUrl;
        }

        public void setFailureUrl(String failureUrl) {
            this.failureUrl = failureUrl;
        }

        public String getFailureForwardUrl() {
            return this.failureForwardUrl;
        }

        public void setFailureForwardUrl(String failureForwardUrl) {
            this.failureForwardUrl = failureForwardUrl;
        }
    }
}

