/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.security.core.definition.domain;

import cn.herodotus.engine.assistant.core.domain.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.Jackson2ArrayOrStringDeserializer;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HerodotusClientDetails
extends BaseDto
implements ClientDetails {
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> scope = Collections.emptySet();
    @JsonProperty(value="resource_ids")
    @JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> resourceIds = Collections.emptySet();
    @JsonProperty(value="authorized_grant_types")
    @JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> authorizedGrantTypes = Collections.emptySet();
    @JsonProperty(value="web_server_redirect_uri")
    @JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> registeredRedirectUris;
    @JsonProperty(value="autoapprove")
    @JsonDeserialize(using=Jackson2ArrayOrStringDeserializer.class)
    private Set<String> autoApproveScopes;
    private List<GrantedAuthority> authorities = Collections.emptyList();
    @JsonProperty(value="access_token_validity")
    private Integer accessTokenValiditySeconds;
    @JsonProperty(value="refresh_token_validity")
    private Integer refreshTokenValiditySeconds;
    @JsonProperty(value="additional_information")
    private Map<String, Object> additionalInformation = new LinkedHashMap<String, Object>();

    public HerodotusClientDetails() {
    }

    public HerodotusClientDetails(ClientDetails prototype) {
        this();
        this.setAccessTokenValiditySeconds(prototype.getAccessTokenValiditySeconds());
        this.setRefreshTokenValiditySeconds(prototype.getRefreshTokenValiditySeconds());
        this.setAuthorities(prototype.getAuthorities());
        this.setAuthorizedGrantTypes(prototype.getAuthorizedGrantTypes());
        this.setClientId(prototype.getClientId());
        this.setClientSecret(prototype.getClientSecret());
        this.setRegisteredRedirectUri(prototype.getRegisteredRedirectUri());
        this.setScope(prototype.getScope());
        this.setResourceIds(prototype.getResourceIds());
    }

    public HerodotusClientDetails(String clientId, String resourceIds, String scopes, String grantTypes, String authorities) {
        this(clientId, resourceIds, scopes, grantTypes, authorities, null);
    }

    public HerodotusClientDetails(String clientId, String resourceIds, String scopes, String grantTypes, String authorities, String redirectUris) {
        Set scopeList;
        Set resources;
        this.clientId = clientId;
        if (StringUtils.hasText((String)resourceIds) && !(resources = StringUtils.commaDelimitedListToSet((String)resourceIds)).isEmpty()) {
            this.resourceIds = resources;
        }
        if (StringUtils.hasText((String)scopes) && !(scopeList = StringUtils.commaDelimitedListToSet((String)scopes)).isEmpty()) {
            this.scope = scopeList;
        }
        this.authorizedGrantTypes = StringUtils.hasText((String)grantTypes) ? StringUtils.commaDelimitedListToSet((String)grantTypes) : new HashSet<String>(Arrays.asList("authorization_code", "refresh_token"));
        if (StringUtils.hasText((String)authorities)) {
            this.authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
        }
        if (StringUtils.hasText((String)redirectUris)) {
            this.registeredRedirectUris = StringUtils.commaDelimitedListToSet((String)redirectUris);
        }
    }

    @JsonIgnore
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAutoApproveScopes(Collection<String> autoApproveScopes) {
        this.autoApproveScopes = new HashSet<String>(autoApproveScopes);
    }

    public boolean isAutoApprove(String scope) {
        if (this.autoApproveScopes == null) {
            return false;
        }
        for (String auto : this.autoApproveScopes) {
            if (!auto.equals("true") && !scope.matches(auto)) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public Set<String> getAutoApproveScopes() {
        return this.autoApproveScopes;
    }

    @JsonIgnore
    public boolean isSecretRequired() {
        return this.clientSecret != null;
    }

    @JsonIgnore
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonIgnore
    public boolean isScoped() {
        return this.scope != null && !this.scope.isEmpty();
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Collection<String> scope) {
        this.scope = scope == null ? Collections.emptySet() : new LinkedHashSet<String>(scope);
    }

    @JsonIgnore
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        this.resourceIds = resourceIds == null ? Collections.emptySet() : new LinkedHashSet<String>(resourceIds);
    }

    @JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(Collection<String> authorizedGrantTypes) {
        this.authorizedGrantTypes = new LinkedHashSet<String>(authorizedGrantTypes);
    }

    @JsonIgnore
    public Set<String> getRegisteredRedirectUri() {
        return this.registeredRedirectUris;
    }

    public void setRegisteredRedirectUri(Set<String> registeredRedirectUris) {
        this.registeredRedirectUris = registeredRedirectUris == null ? null : new LinkedHashSet<String>(registeredRedirectUris);
    }

    @JsonProperty(value="authorities")
    public Collection<GrantedAuthority> getAuthorities() {
        if (this.authorities == null) {
            return new ArrayList<GrantedAuthority>();
        }
        return this.authorities;
    }

    @JsonIgnore
    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = new ArrayList<GrantedAuthority>(authorities);
    }

    @JsonProperty(value="authorities")
    public void setAuthoritiesExt(Collection<GrantedAuthority> authorities) {
        this.authorities = new ArrayList<GrantedAuthority>(authorities);
    }

    @JsonIgnore
    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @JsonIgnore
    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setAdditionalInformation(Map<String, Object> additionalInformation) {
        this.additionalInformation = new LinkedHashMap<String, Object>(additionalInformation);
    }

    @JsonAnySetter
    public Map<String, Object> getAdditionalInformation() {
        return Collections.unmodifiableMap(this.additionalInformation);
    }

    @JsonAnySetter
    public void addAdditionalInformation(String key, Object value) {
        this.additionalInformation.put(key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessTokenValiditySeconds == null ? 0 : this.accessTokenValiditySeconds);
        result = 31 * result + (this.refreshTokenValiditySeconds == null ? 0 : this.refreshTokenValiditySeconds);
        result = 31 * result + (this.authorities == null ? 0 : this.authorities.hashCode());
        result = 31 * result + (this.authorizedGrantTypes == null ? 0 : this.authorizedGrantTypes.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = 31 * result + (this.registeredRedirectUris == null ? 0 : this.registeredRedirectUris.hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : this.resourceIds.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.additionalInformation == null ? 0 : this.additionalInformation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HerodotusClientDetails other = (HerodotusClientDetails)((Object)obj);
        if (this.accessTokenValiditySeconds == null ? other.accessTokenValiditySeconds != null : !this.accessTokenValiditySeconds.equals(other.accessTokenValiditySeconds)) {
            return false;
        }
        if (this.refreshTokenValiditySeconds == null ? other.refreshTokenValiditySeconds != null : !this.refreshTokenValiditySeconds.equals(other.refreshTokenValiditySeconds)) {
            return false;
        }
        if (this.authorities == null ? other.authorities != null : !this.authorities.equals(other.authorities)) {
            return false;
        }
        if (this.authorizedGrantTypes == null ? other.authorizedGrantTypes != null : !this.authorizedGrantTypes.equals(other.authorizedGrantTypes)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientSecret == null ? other.clientSecret != null : !this.clientSecret.equals(other.clientSecret)) {
            return false;
        }
        if (this.registeredRedirectUris == null ? other.registeredRedirectUris != null : !this.registeredRedirectUris.equals(other.registeredRedirectUris)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !this.resourceIds.equals(other.resourceIds)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.additionalInformation == null) {
            return other.additionalInformation == null;
        }
        return this.additionalInformation.equals(other.additionalInformation);
    }

    public String toString() {
        return "OauthClientDetails{clientId='" + this.clientId + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", accessTokenValiditySeconds=" + this.accessTokenValiditySeconds + ", refreshTokenValiditySeconds=" + this.refreshTokenValiditySeconds + '}';
    }
}

