/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.autoconfigure;

import cn.herodotus.engine.rest.autoconfigure.RestTemplateAutoConfiguration;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.client.RestClientBuilderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration.class, RestTemplateAutoConfiguration.class})
public class RestClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestClientAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Auto [Rest Client] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    RestClient.Builder restClientBuilder(RestClientBuilderConfigurer restClientBuilderConfigurer, RestTemplate restTemplate) {
        return restClientBuilderConfigurer.configure(RestClient.builder((RestTemplate)restTemplate));
    }

    @Bean
    @ConditionalOnMissingBean
    public RestClient restClient(RestClient.Builder restClientBuilder) {
        RestClient restClient = restClientBuilder.build();
        log.trace("[Herodotus] |- Bean [RestClient] Configure.");
        return restClient;
    }
}

