/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.autoconfigure;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration.class})
public class RestTemplateAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Module [Rest Template] Auto Configure.");
    }

    @Bean
    @LoadBalanced
    public RestTemplate getRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        ResponseErrorHandler responseErrorHandler = new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                return true;
            }

            public void handleError(ClientHttpResponse response) throws IOException {
            }
        };
        RestTemplate restTemplate = restTemplateBuilder.errorHandler(responseErrorHandler).build();
        log.trace("[Herodotus] |- Bean [Rest Template] Auto Configure.");
        return restTemplate;
    }
}

